/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.AbstractVisualTypeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.GetElementTypeOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.GetLinkTypeOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.GetNodeTypeOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.IVisualTypeOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.IVisualTypeProvider;

public class VisualTypeService
extends Service
implements IVisualTypeProvider {
    private static final VisualTypeService INSTANCE = new VisualTypeService();

    static {
        INSTANCE.configureProviders("org.eclipse.papyrus.infra.gmfdiag.common", "visualTypeProviders");
    }

    private VisualTypeService() {
        super(true, true);
    }

    public static VisualTypeService getInstance() {
        return INSTANCE;
    }

    protected Object getCachingKey(IOperation operation) {
        return ((IVisualTypeOperation)operation).getDiagramType();
    }

    public String getPriority(IConfigurationElement element) {
        String priority;
        String result = ProviderPriority.LOWEST.getName();
        IConfigurationElement[] priorities = element.getChildren("Priority");
        if (priorities.length > 0 && !Strings.isNullOrEmpty((String)(priority = priorities[0].getAttribute("name")))) {
            result = priority;
        }
        return result;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        class VTPDesc
        extends ActivityFilterProviderDescriptor {
            private final String diagramType;

            public VTPDesc(IConfigurationElement element) {
                super(element);
                this.diagramType = element.getAttribute("diagramType");
            }

            public boolean provides(IOperation operation) {
                return operation instanceof IVisualTypeOperation && Objects.equal((Object)((IVisualTypeOperation)operation).getDiagramType(), (Object)this.diagramType) && super.provides(operation);
            }

            public IProvider getProvider() {
                IProvider result = this.provider;
                if (result == null) {
                    result = super.getProvider();
                    if (result == null) {
                        Activator.log.warn(String.format("Provider initialization failed for <%s> in %s.", this.getElement().getName(), this.getElement().getContributor().getName()));
                        result = this.provider = new NullProvider();
                    } else {
                        ((AbstractVisualTypeProvider)result).setConfiguration(this.getElement());
                    }
                }
                return result;
            }
        }
        return new VTPDesc(element);
    }

    @Override
    public IElementType getElementType(Diagram diagram, String viewType) {
        GetElementTypeOperation operation = new GetElementTypeOperation(diagram, viewType);
        List result = ExecutionStrategy.FIRST.execute((Service)this, (IOperation)operation);
        return result.isEmpty() ? null : (IElementType)result.get(0);
    }

    @Override
    public String getNodeType(View parentView, EObject element) {
        GetNodeTypeOperation operation = new GetNodeTypeOperation(parentView, element);
        List result = ExecutionStrategy.FIRST.execute((Service)this, (IOperation)operation);
        return result.isEmpty() ? null : (String)result.get(0);
    }

    @Override
    public String getLinkType(Diagram diagram, EObject element) {
        GetLinkTypeOperation operation = new GetLinkTypeOperation(diagram, element);
        List result = ExecutionStrategy.FIRST.execute((Service)this, (IOperation)operation);
        return result.isEmpty() ? null : (String)result.get(0);
    }

    private static final class NullProvider
    implements IVisualTypeProvider {
        private NullProvider() {
        }

        public boolean provides(IOperation operation) {
            return false;
        }

        public void addProviderChangeListener(IProviderChangeListener listener) {
        }

        public void removeProviderChangeListener(IProviderChangeListener listener) {
        }

        @Override
        public IElementType getElementType(Diagram diagram, String viewType) {
            return null;
        }

        @Override
        public String getNodeType(View parentView, EObject element) {
            return null;
        }

        @Override
        public String getLinkType(Diagram diagram, EObject element) {
            return null;
        }
    }
}

