/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.InternalBrowserInstance;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;

public class InternalBrowserEditorInstance
extends InternalBrowserInstance {
    public InternalBrowserEditorInstance(String id, int style, String name, String tooltip) {
        super(id, style, name, tooltip);
    }

    public void openURL(URL url) throws PartInitException {
        WebBrowserEditorInput input = new WebBrowserEditorInput(url, this.style, this.getId());
        input.setName(this.name);
        input.setToolTipText(this.tooltip);
        WebBrowserEditor editor = (WebBrowserEditor)this.part;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        if (page == null) {
            throw new PartInitException(Messages.errorCouldNotLaunchInternalWebBrowser);
        }
        if (editor != null) {
            editor.init(editor.getEditorSite(), input);
            page.activate((IWorkbenchPart)editor);
        } else {
            try {
                IEditorPart editorPart = page.openEditor((IEditorInput)input, "org.eclipse.ui.browser.editor");
                this.hookPart(page, (IWorkbenchPart)editorPart);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error opening Web browser", e);
            }
        }
    }

    public boolean close() {
        try {
            return ((WebBrowserEditor)this.part).close();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

