/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.ServiceLocator;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientTransport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class UserAgentUtil {
    public static String computeUserAgent() {
        Bundle mpcCoreBundle = FrameworkUtil.getBundle(HttpClientTransport.class);
        BundleContext context = mpcCoreBundle.getBundleContext();
        String version = UserAgentUtil.getAgentVersion(mpcCoreBundle);
        String java = UserAgentUtil.getAgentJava(context);
        String os = UserAgentUtil.getAgentOS(context);
        String language = UserAgentUtil.getProperty(context, "osgi.nl", "en");
        String agentDetail = UserAgentUtil.getAgentDetail(context);
        String userAgent = MessageFormat.format("mpc/{0} ({1}; {2}; {3}) {4}", version, java, os, language, agentDetail);
        return userAgent;
    }

    private static String getAgentVersion(Bundle bundle) {
        return UserAgentUtil.formatVersion(bundle.getVersion());
    }

    private static String formatVersion(String version) {
        try {
            return UserAgentUtil.formatVersion(Version.parseVersion((String)version));
        }
        catch (RuntimeException ex) {
            String[] parts = version.split("[\\._\\-]", 4);
            String shortVersion = Arrays.stream(parts).limit(3L).map(part -> part == null || part.trim().isEmpty() ? "0" : part).collect(Collectors.joining("."));
            return shortVersion;
        }
    }

    private static String formatVersion(Version version) {
        return MessageFormat.format("{0}.{1}.{2}", version.getMajor(), version.getMinor(), version.getMicro());
    }

    private static String getAgentJava(BundleContext context) {
        String javaName = UserAgentUtil.getProperty(context, "java.runtime.name", UserAgentUtil.getProperty(context, "java.vendor", "Unknown Java"));
        if (javaName.endsWith("Runtime Environment")) {
            javaName = javaName.substring(0, javaName.length() - "Runtime Environment".length());
        }
        String javaVersion = UserAgentUtil.getProperty(context, "java.runtime.version", UserAgentUtil.getProperty(context, "java.version", "0.0.0"));
        String java = MessageFormat.format("{0} {1}", javaName, javaVersion);
        return java;
    }

    private static String getAgentOS(BundleContext context) {
        String osName = UserAgentUtil.getProperty(context, "org.osgi.framework.os.name", null);
        String osVersion = UserAgentUtil.getProperty(context, "org.osgi.framework.os.version", "Unknown Version");
        String osArch = UserAgentUtil.getProperty(context, "org.osgi.framework.processor", "Unknown Arch");
        String os = osName == null ? "Unknown OS" : MessageFormat.format("{0} {1} {2}", osName, osVersion, osArch);
        return os;
    }

    private static String getAgentDetail(BundleContext context) {
        String agentDetail = UserAgentUtil.getProperty(context, HttpClientTransport.USER_AGENT_PROPERTY, null);
        if (agentDetail == null) {
            IProduct product;
            String productId = UserAgentUtil.getProperty(context, "eclipse.product", null);
            String productVersion = UserAgentUtil.getProperty(context, "eclipse.buildId", null);
            if (productId == null || productVersion == null) {
                Map<String, String> defaultRequestMetaParameters = ServiceLocator.computeProductInfo();
                productId = UserAgentUtil.getProperty(defaultRequestMetaParameters, (Object)"product", null);
                productVersion = UserAgentUtil.getProperty(defaultRequestMetaParameters, (Object)"product.version", "Unknown Build");
            }
            if (productId == null) {
                agentDetail = "Unknown Product";
            } else if (productVersion == null) {
                agentDetail = productId;
            } else {
                productVersion = UserAgentUtil.formatVersion(productVersion);
                agentDetail = MessageFormat.format("{0}/{1}", productId, productVersion);
            }
            String appId = UserAgentUtil.getProperty(context, "eclipse.application", null);
            if (appId == null && (product = Platform.getProduct()) != null) {
                appId = product.getApplication();
            }
            if (appId != null) {
                agentDetail = MessageFormat.format("{0} ({1})", agentDetail, appId);
            }
        }
        return agentDetail;
    }

    private static String getProperty(BundleContext context, String key, String defaultValue) {
        String value = context.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static String getProperty(Map<?, String> properties, Object key, String defaultValue) {
        String value = properties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

