/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidityFactory;
import org.eclipse.ocl.examples.emf.validation.validity.ValidityPackage;
import org.eclipse.ocl.examples.emf.validation.validity.impl.ConstrainingNodeImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.LeafConstrainingNodeImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.ResultConstrainingNodeImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.ResultImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.ResultSetImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.ResultValidatableNodeImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.RootConstrainingNodeImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.RootNodeImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.RootValidatableNodeImpl;
import org.eclipse.ocl.examples.emf.validation.validity.impl.ValidatableNodeImpl;

public class ValidityFactoryImpl
extends EFactoryImpl
implements ValidityFactory {
    public static ValidityFactory init() {
        try {
            ValidityFactory theValidityFactory = (ValidityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/validation/2013/Validity");
            if (theValidityFactory != null) {
                return theValidityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ValidityFactoryImpl();
    }

    public @NonNull EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createConstrainingNode();
            }
            case 2: {
                return this.createLeafConstrainingNode();
            }
            case 3: {
                return this.createResult();
            }
            case 4: {
                return this.createResultConstrainingNode();
            }
            case 5: {
                return this.createResultSet();
            }
            case 6: {
                return this.createResultValidatableNode();
            }
            case 7: {
                return this.createRootNode();
            }
            case 8: {
                return this.createRootConstrainingNode();
            }
            case 9: {
                return this.createRootValidatableNode();
            }
            case 10: {
                return this.createValidatableNode();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createSeverityFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createThrowableFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertSeverityToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertThrowableToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public @NonNull ConstrainingNode createConstrainingNode() {
        ConstrainingNodeImpl constrainingNode = new ConstrainingNodeImpl();
        return constrainingNode;
    }

    @Override
    public @NonNull LeafConstrainingNode createLeafConstrainingNode() {
        LeafConstrainingNodeImpl leafConstrainingNode = new LeafConstrainingNodeImpl();
        return leafConstrainingNode;
    }

    @Override
    public @NonNull Result createResult() {
        ResultImpl result = new ResultImpl();
        return result;
    }

    @Override
    public @NonNull ResultConstrainingNode createResultConstrainingNode() {
        ResultConstrainingNodeImpl resultConstrainingNode = new ResultConstrainingNodeImpl();
        return resultConstrainingNode;
    }

    @Override
    public @NonNull ResultSet createResultSet() {
        ResultSetImpl resultSet = new ResultSetImpl();
        return resultSet;
    }

    @Override
    public @NonNull ResultValidatableNode createResultValidatableNode() {
        ResultValidatableNodeImpl resultValidatableNode = new ResultValidatableNodeImpl();
        return resultValidatableNode;
    }

    @Override
    public @NonNull RootNode createRootNode() {
        RootNodeImpl rootNode = new RootNodeImpl();
        return rootNode;
    }

    @Override
    public @NonNull RootConstrainingNode createRootConstrainingNode() {
        RootConstrainingNodeImpl rootConstrainingNode = new RootConstrainingNodeImpl();
        return rootConstrainingNode;
    }

    @Override
    public @NonNull RootValidatableNode createRootValidatableNode() {
        RootValidatableNodeImpl rootValidatableNode = new RootValidatableNodeImpl();
        return rootValidatableNode;
    }

    @Override
    public @NonNull ValidatableNode createValidatableNode() {
        ValidatableNodeImpl validatableNode = new ValidatableNodeImpl();
        return validatableNode;
    }

    public Severity createSeverityFromString(EDataType eDataType, String initialValue) {
        Severity result = Severity.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSeverityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Throwable createThrowableFromString(EDataType eDataType, String initialValue) {
        return (Throwable)super.createFromString(eDataType, initialValue);
    }

    public String convertThrowableToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ValidityPackage getValidityPackage() {
        return (ValidityPackage)this.getEPackage();
    }

    @Deprecated
    public static ValidityPackage getPackage() {
        return ValidityPackage.eINSTANCE;
    }
}

