/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;

public class SynchronizeModelUpdateHandler
extends BackgroundEventHandler
implements IResourceChangeListener,
ISyncInfoSetChangeListener {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private static final int MARKERS_CHANGED = 1;
    private static final int BUSY_STATE_CHANGED = 2;
    private static final int RESET = 3;
    private static final int SYNC_INFO_SET_CHANGED = 4;
    private AbstractSynchronizeModelProvider provider;
    private Set<ISynchronizeModelElement> pendingLabelUpdates = Collections.synchronizedSet(new HashSet());
    private boolean dispatchEarly = false;
    private static final int EARLY_DISPATCH_INCREMENT = 100;
    private IPropertyChangeListener listener = event -> {
        Object source;
        if (event.getProperty() == "org.eclipse.team.ui.busy" && (source = event.getSource()) instanceof ISynchronizeModelElement) {
            this.updateBusyState((ISynchronizeModelElement)source, (Boolean)event.getNewValue());
        }
    };
    private boolean performingBackgroundUpdate;
    private Map<ISynchronizeModelElement, Set<ISynchronizeModelElement>> additionsMap;

    public SynchronizeModelUpdateHandler(AbstractSynchronizeModelProvider provider) {
        super(TeamUIMessages.SynchronizeModelProvider_0, TeamUIMessages.SynchronizeModelUpdateHandler_0);
        this.provider = provider;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        provider.getSyncInfoSet().addSyncSetChangedListener((ISyncInfoSetChangeListener)this);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    public StructuredViewer getViewer() {
        return this.provider.getViewer();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        String[] markerTypes = this.getMarkerTypes();
        HashSet<IResource> handledResources = new HashSet<IResource>();
        HashSet changes = new HashSet();
        String[] stringArray = markerTypes;
        int n = markerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta[] markerDeltas;
            String markerType = stringArray[n2];
            IMarkerDelta[] iMarkerDeltaArray = markerDeltas = event.findMarkerDeltas(markerType, true);
            int n3 = markerDeltas.length;
            int n4 = 0;
            while (n4 < n3) {
                IMarkerDelta delta = iMarkerDeltaArray[n4];
                IResource resource = delta.getResource();
                if (!handledResources.contains(resource)) {
                    handledResources.add(resource);
                    ISynchronizeModelElement[] elements = this.provider.getClosestExistingParents(delta.getResource());
                    if (elements != null && elements.length > 0) {
                        Collections.addAll(changes, elements);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!changes.isEmpty()) {
            this.updateMarkersFor(changes.toArray(new ISynchronizeModelElement[changes.size()]));
        }
    }

    private void updateMarkersFor(ISynchronizeModelElement[] elements) {
        this.queueEvent(new MarkerChangeEvent(elements), false);
    }

    protected void updateBusyState(ISynchronizeModelElement element, boolean isBusy) {
        this.queueEvent(new BusyStateChangeEvent(element, isBusy), false);
    }

    protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws CoreException {
        switch (event.getType()) {
            case 1000: {
                this.executeRunnable(event, monitor);
                break;
            }
            case 1: {
                ISynchronizeModelElement[] elements;
                long start = System.currentTimeMillis();
                ISynchronizeModelElement[] iSynchronizeModelElementArray = elements = this.getChangedElements(event);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    ISynchronizeModelElement element = iSynchronizeModelElementArray[n2];
                    this.propagateProblemMarkers(element);
                    this.updateParentLabels(element);
                    ++n2;
                }
                if (!Policy.DEBUG_SYNC_MODELS) break;
                long time = System.currentTimeMillis() - start;
                SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("m:ss.SSS");
                String took = TIME_FORMAT.format(new Date(time));
                System.out.println(String.valueOf(took) + " for " + elements.length + " files");
                break;
            }
            case 2: {
                BusyStateChangeEvent e = (BusyStateChangeEvent)event;
                this.queueForLabelUpdate(e.getElement());
                if (!e.isBusy()) break;
                this.dispatchEarly = true;
                break;
            }
            case 3: {
                this.pendingLabelUpdates.clear();
                this.provider.reset();
                break;
            }
            case 4: {
                this.handleChanges(((SyncInfoSetChangeEvent)event).getEvent(), monitor);
            }
        }
    }

    private ISynchronizeModelElement[] getChangedElements(BackgroundEventHandler.Event event) {
        if (event.getType() == 1) {
            return ((MarkerChangeEvent)event).getElements();
        }
        return new ISynchronizeModelElement[0];
    }

    protected boolean doDispatchEvents(IProgressMonitor monitor) throws TeamException {
        this.dispatchEarly = false;
        if (this.pendingLabelUpdates.isEmpty()) {
            return false;
        }
        Utils.asyncExec(this::firePendingLabelUpdates, this.getViewer());
        return true;
    }

    protected void firePendingLabelUpdates() {
        if (!Utils.canUpdateViewer(this.getViewer())) {
            return;
        }
        try {
            Object[] updates = this.pendingLabelUpdates.toArray(new Object[this.pendingLabelUpdates.size()]);
            this.updateLabels(updates);
        }
        finally {
            this.pendingLabelUpdates.clear();
        }
    }

    private void updateLabels(Object[] elements) {
        StructuredViewer tree = this.getViewer();
        if (Utils.canUpdateViewer(tree)) {
            tree.update(elements, null);
        }
    }

    public void updateParentLabels(ISynchronizeModelElement element) {
        this.queueForLabelUpdate(element);
        while (element.getParent() != null) {
            element = (ISynchronizeModelElement)element.getParent();
            this.queueForLabelUpdate(element);
        }
    }

    protected void queueForLabelUpdate(ISynchronizeModelElement diffNode) {
        this.pendingLabelUpdates.add(diffNode);
    }

    private void propagateProblemMarkers(ISynchronizeModelElement element) {
        ISynchronizeModelElement parent;
        String property;
        boolean recalculateParentDecorations;
        IResource resource = element.getResource();
        if (resource != null && (recalculateParentDecorations = this.hadProblemProperty(element, property = this.provider.calculateProblemMarker(element))) && (parent = (ISynchronizeModelElement)element.getParent()) != null) {
            this.propagateProblemMarkers(parent);
        }
    }

    private boolean hadProblemProperty(ISynchronizeModelElement element, String property) {
        boolean hadError = element.getProperty("org.eclipse.team.ui.error");
        boolean hadWarning = element.getProperty("org.eclipse.team.ui.warning");
        IResource resource = element.getResource();
        if (resource != null && resource.isPhantom()) {
            return true;
        }
        if (hadError) {
            if (property != "org.eclipse.team.ui.error") {
                element.setPropertyToRoot("org.eclipse.team.ui.error", false);
                if (property != null) {
                    element.setPropertyToRoot(property, true);
                }
                return true;
            }
            return false;
        }
        if (hadWarning) {
            if (property != "org.eclipse.team.ui.warning") {
                element.setPropertyToRoot("org.eclipse.team.ui.warning", false);
                if (property != null) {
                    element.setPropertyToRoot(property, true);
                    return false;
                }
                return true;
            }
            return false;
        }
        if (property == "org.eclipse.team.ui.error") {
            element.setPropertyToRoot(property, true);
            return false;
        }
        if (property == "org.eclipse.team.ui.warning") {
            element.setPropertyToRoot(property, true);
            return true;
        }
        return false;
    }

    private void reset() {
        this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent((IResource)ROOT, 3, 2), false);
    }

    public void dispose() {
        this.shutdown();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.provider.getSyncInfoSet().removeSyncSetChangedListener((ISyncInfoSetChangeListener)this);
    }

    protected long getShortDispatchDelay() {
        if (this.dispatchEarly) {
            this.dispatchEarly = false;
            return 100L;
        }
        return super.getShortDispatchDelay();
    }

    public void nodeAdded(ISynchronizeModelElement element, AbstractSynchronizeModelProvider provider) {
        element.addPropertyChangeListener(this.listener);
        this.provider.nodeAdded(element, provider);
        if (Policy.DEBUG_SYNC_MODELS) {
            System.out.println("Node added: " + this.getDebugDisplayLabel(element) + " -> " + this.getDebugDisplayLabel((ISynchronizeModelElement)element.getParent()) + " : " + this.getDebugDisplayLabel(provider));
        }
    }

    public void nodeRemoved(ISynchronizeModelElement element, AbstractSynchronizeModelProvider provider) {
        element.removePropertyChangeListener(this.listener);
        this.provider.nodeRemoved(element, provider);
        if (Policy.DEBUG_SYNC_MODELS) {
            System.out.println("Node removed: " + this.getDebugDisplayLabel(element) + " -> " + this.getDebugDisplayLabel((ISynchronizeModelElement)element.getParent()) + " : " + this.getDebugDisplayLabel(provider));
        }
    }

    public void modelObjectCleared(ISynchronizeModelElement node) {
        node.removePropertyChangeListener(this.listener);
        this.provider.modelObjectCleared(node);
        if (Policy.DEBUG_SYNC_MODELS) {
            System.out.println("Node cleared: " + this.getDebugDisplayLabel(node));
        }
    }

    private String getDebugDisplayLabel(ISynchronizeModelElement node) {
        if (node == null) {
            return "ROOT";
        }
        if (node.getResource() != null) {
            return node.getResource().getFullPath().toString();
        }
        return node.getName();
    }

    private String getDebugDisplayLabel(AbstractSynchronizeModelProvider provider2) {
        return provider2.toString();
    }

    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        if (this.provider.isDisposed()) {
            set.removeSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        } else {
            this.reset();
        }
    }

    public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        if (!(event instanceof ISyncInfoTreeChangeEvent)) {
            this.reset();
        } else {
            this.queueEvent(new SyncInfoSetChangeEvent(event), false);
        }
    }

    private void handleChanges(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        this.runViewUpdate(() -> {
            this.provider.handleChanges((ISyncInfoTreeChangeEvent)event, monitor);
            this.firePendingLabelUpdates();
        }, true);
    }

    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
    }

    public ISynchronizeModelProvider getProvider() {
        return this.provider;
    }

    public void connect(IProgressMonitor monitor) {
        this.getProvider().getSyncInfoSet().connect((ISyncInfoSetChangeListener)this, monitor);
    }

    public void runViewUpdate(Runnable runnable, boolean preserveExpansion) {
        if (Utils.canUpdateViewer(this.getViewer()) || this.isPerformingBackgroundUpdate()) {
            this.internalRunViewUpdate(runnable, preserveExpansion);
        } else {
            Control ctrl;
            if (Thread.currentThread() != this.getEventHandlerJob().getThread()) {
                TeamUIPlugin.log(2, "View update invoked from invalid thread", new TeamException("View update invoked from invalid thread"));
            }
            if ((ctrl = this.getViewer().getControl()) != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().syncExec(() -> {
                    if (!ctrl.isDisposed()) {
                        BusyIndicator.showWhile((Display)ctrl.getDisplay(), () -> this.internalRunViewUpdate(runnable, preserveExpansion));
                    }
                });
            }
        }
    }

    public boolean isPerformingBackgroundUpdate() {
        return Thread.currentThread() == this.getEventHandlerJob().getThread() && this.performingBackgroundUpdate;
    }

    private void internalRunViewUpdate(Runnable runnable, boolean preserveExpansion) {
        ISynchronizeModelElement root;
        block17: {
            StructuredViewer viewer = this.getViewer();
            IResource[] expanded = null;
            IResource[] selected = null;
            try {
                if (Utils.canUpdateViewer(viewer)) {
                    viewer.getControl().setRedraw(false);
                    if (preserveExpansion) {
                        expanded = this.provider.getExpandedResources();
                        selected = this.provider.getSelectedResources();
                    }
                    if (viewer instanceof AbstractTreeViewer && this.additionsMap == null) {
                        this.additionsMap = new HashMap<ISynchronizeModelElement, Set<ISynchronizeModelElement>>();
                    }
                }
                runnable.run();
            }
            finally {
                if (!Utils.canUpdateViewer(viewer)) break block17;
                try {
                    if (this.additionsMap != null && !this.additionsMap.isEmpty() && Utils.canUpdateViewer(viewer)) {
                        for (ISynchronizeModelElement parent : this.additionsMap.keySet()) {
                            if (Policy.DEBUG_SYNC_MODELS) {
                                System.out.println("Adding child view items of " + parent.getName());
                            }
                            Set<ISynchronizeModelElement> toAdd = this.additionsMap.get(parent);
                            ((AbstractTreeViewer)viewer).add((Object)parent, toAdd.toArray(new Object[toAdd.size()]));
                        }
                        this.additionsMap = null;
                    }
                    if (expanded != null) {
                        this.provider.expandResources(expanded);
                    }
                    if (selected != null) {
                        this.provider.selectResources(selected);
                    }
                }
                finally {
                    viewer.getControl().setRedraw(true);
                }
            }
        }
        if ((root = this.provider.getModelRoot()) instanceof SynchronizeModelElement) {
            ((SynchronizeModelElement)root).fireChanges();
        }
    }

    public void performUpdate(IWorkspaceRunnable runnable, boolean preserveExpansion, boolean updateInUIThread) {
        if (updateInUIThread) {
            this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.RunnableEvent(this.getUIUpdateRunnable(runnable, preserveExpansion), true), true);
        } else {
            this.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.RunnableEvent(this.getBackgroundUpdateRunnable(runnable, preserveExpansion), true), true);
        }
    }

    private IWorkspaceRunnable getUIUpdateRunnable(IWorkspaceRunnable runnable, boolean preserveExpansion) {
        return monitor -> {
            CoreException[] exception = new CoreException[1];
            this.runViewUpdate(() -> {
                try {
                    runnable.run(monitor);
                }
                catch (CoreException e) {
                    coreExceptionArray[0] = e;
                }
            }, true);
            if (exception[0] != null) {
                throw exception[0];
            }
        };
    }

    private IWorkspaceRunnable getBackgroundUpdateRunnable(final IWorkspaceRunnable runnable, final boolean preserveExpansion) {
        return new IWorkspaceRunnable(){
            IResource[] expanded;
            IResource[] selected;

            public void run(IProgressMonitor monitor) throws CoreException {
                if (preserveExpansion) {
                    this.recordExpandedResources();
                }
                try {
                    SynchronizeModelUpdateHandler.this.performingBackgroundUpdate = true;
                    runnable.run(monitor);
                }
                finally {
                    SynchronizeModelUpdateHandler.this.performingBackgroundUpdate = false;
                }
                this.updateView();
            }

            private void recordExpandedResources() {
                StructuredViewer viewer = SynchronizeModelUpdateHandler.this.getViewer();
                if (viewer != null && !viewer.getControl().isDisposed() && viewer instanceof AbstractTreeViewer) {
                    viewer.getControl().getDisplay().syncExec(() -> {
                        if (viewer != null && !viewer.getControl().isDisposed()) {
                            this.expanded = SynchronizeModelUpdateHandler.this.provider.getExpandedResources();
                            this.selected = SynchronizeModelUpdateHandler.this.provider.getSelectedResources();
                        }
                    });
                }
            }

            private void updateView() {
                SynchronizeModelUpdateHandler.this.runViewUpdate(() -> {
                    SynchronizeModelUpdateHandler.this.provider.getViewer().refresh();
                    if (this.expanded != null) {
                        SynchronizeModelUpdateHandler.this.provider.expandResources(this.expanded);
                    }
                    if (this.selected != null) {
                        SynchronizeModelUpdateHandler.this.provider.selectResources(this.selected);
                    }
                }, false);
            }
        };
    }

    private void executeRunnable(BackgroundEventHandler.Event event, IProgressMonitor monitor) {
        try {
            this.dispatchEvents(Policy.subMonitorFor(monitor, 1));
        }
        catch (TeamException e) {
            this.handleException((CoreException)((Object)e));
        }
        try {
            ((BackgroundEventHandler.RunnableEvent)event).run(Policy.subMonitorFor(monitor, 1));
        }
        catch (CoreException e) {
            this.handleException(e);
        }
    }

    protected void doAdd(ISynchronizeModelElement parent, ISynchronizeModelElement element) {
        if (this.additionsMap == null) {
            if (Policy.DEBUG_SYNC_MODELS) {
                System.out.println("Added view item " + element.getName());
            }
            AbstractTreeViewer viewer = (AbstractTreeViewer)this.getViewer();
            viewer.add((Object)parent, (Object)element);
        } else {
            Set<ISynchronizeModelElement> toAdd;
            if (Policy.DEBUG_SYNC_MODELS) {
                System.out.println("Queueing view item for addition " + element.getName());
            }
            if ((toAdd = this.additionsMap.get(parent)) == null) {
                toAdd = new HashSet<ISynchronizeModelElement>();
                this.additionsMap.put(parent, toAdd);
            }
            toAdd.add(element);
        }
    }

    static class BusyStateChangeEvent
    extends BackgroundEventHandler.Event {
        private final ISynchronizeModelElement element;
        private final boolean isBusy;

        public BusyStateChangeEvent(ISynchronizeModelElement element, boolean isBusy) {
            super(2);
            this.element = element;
            this.isBusy = isBusy;
        }

        public ISynchronizeModelElement getElement() {
            return this.element;
        }

        public boolean isBusy() {
            return this.isBusy;
        }
    }

    static class MarkerChangeEvent
    extends BackgroundEventHandler.Event {
        private final ISynchronizeModelElement[] elements;

        public MarkerChangeEvent(ISynchronizeModelElement[] elements) {
            super(1);
            this.elements = elements;
        }

        public ISynchronizeModelElement[] getElements() {
            return this.elements;
        }
    }

    static class SyncInfoSetChangeEvent
    extends BackgroundEventHandler.Event {
        private final ISyncInfoSetChangeEvent event;

        public SyncInfoSetChangeEvent(ISyncInfoSetChangeEvent event) {
            super(4);
            this.event = event;
        }

        public ISyncInfoSetChangeEvent getEvent() {
            return this.event;
        }
    }
}

