/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.Map;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.gef.editparts.ViewportMouseWheelHelper;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.ui.palette.editparts.IPinnableEditPart;
import org.eclipse.gef.ui.palette.editparts.PaletteAnimator;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class DrawerEditPart
extends PaletteEditPart
implements IPinnableEditPart {
    private static final String PROPERTY_EXPANSION_STATE = "expansion";
    private static final String PROPERTY_PINNED_STATE = "pinned";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DrawerEditPart(PaletteDrawer drawer) {
        super(drawer);
    }

    public IFigure createFigure() {
        DrawerFigure fig = new DrawerFigure(this.getViewer().getControl()){

            IFigure buildTooltip() {
                return DrawerEditPart.this.createToolTip();
            }
        };
        fig.setExpanded(this.getDrawer().isInitiallyOpen());
        fig.setPinned(this.getDrawer().isInitiallyPinned());
        fig.getCollapseToggle().addFocusListener((FocusListener)new FocusListener.Stub(){

            public void focusGained(FocusEvent fe) {
                DrawerEditPart.this.getViewer().select(DrawerEditPart.this);
            }
        });
        fig.getScrollpane().getContents().addLayoutListener((LayoutListener)this.getPaletteAnimator());
        return fig;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.ExposeHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            ViewportExposeHelper helper = new ViewportExposeHelper(this);
            helper.setMinimumFrameCount(6);
            helper.setMargin(new Insets(7, 0, 7, 0));
            return helper;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.MouseWheelHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return new ViewportMouseWheelHelper(this);
        }
        return super.getAdapter(key);
    }

    private PaletteAnimator getPaletteAnimator() {
        Map map = this.getViewer().getEditPartRegistry();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gef.ui.palette.editparts.PaletteAnimator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PaletteAnimator)((Object)map.get(clazz));
    }

    public PaletteDrawer getDrawer() {
        return (PaletteDrawer)this.getPaletteEntry();
    }

    public DrawerFigure getDrawerFigure() {
        return (DrawerFigure)this.getFigure();
    }

    public IFigure getContentPane() {
        return this.getDrawerFigure().getContentPane();
    }

    public boolean isExpanded() {
        return this.getDrawerFigure().isExpanded();
    }

    public boolean isPinnedOpen() {
        return this.getDrawerFigure().isPinnedOpen();
    }

    protected boolean nameNeededInToolTip() {
        return false;
    }

    public boolean canBePinned() {
        return this.getDrawerFigure().isPinShowing();
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getDescription(AccessibleEvent e) {
                e.result = DrawerEditPart.this.getPaletteEntry().getDescription();
            }

            public void getName(AccessibleEvent e) {
                e.result = DrawerEditPart.this.getPaletteEntry().getLabel();
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 35;
            }

            public void getState(AccessibleControlEvent e) {
                super.getState(e);
                e.detail = e.detail | (DrawerEditPart.this.isExpanded() ? 512 : 1024);
            }
        };
    }

    protected void refreshVisuals() {
        this.getDrawerFigure().setToolTip(this.createToolTip());
        ImageDescriptor img = this.getDrawer().getSmallIcon();
        if (img == null && this.getDrawer().showDefaultIcon()) {
            img = InternalImages.DESC_FOLDER_OPEN;
        }
        this.setImageDescriptor(img);
        this.getDrawerFigure().setTitle(this.getPaletteEntry().getLabel());
        this.getDrawerFigure().setLayoutMode(this.getLayoutSetting());
        boolean showPin = this.getPreferenceSource().getAutoCollapseSetting() == 0;
        this.getDrawerFigure().showPin(showPin);
        Color background = this.getDrawer().getDrawerType().equals("$Palette Template") ? PaletteColorUtil.WIDGET_LIST_BACKGROUND : null;
        this.getDrawerFigure().getScrollpane().setBackgroundColor(background);
    }

    protected void register() {
        super.register();
        this.getPaletteAnimator().addDrawer(this);
        this.getFigure().addLayoutListener((LayoutListener)this.getPaletteAnimator());
    }

    public void restoreState(IMemento memento) {
        this.setExpanded(new Boolean(memento.getString(PROPERTY_EXPANSION_STATE)));
        this.setPinnedOpen(new Boolean(memento.getString(PROPERTY_PINNED_STATE)));
        RangeModel rModel = this.getDrawerFigure().getScrollpane().getViewport().getVerticalRangeModel();
        rModel.setMinimum(memento.getInteger("minimum").intValue());
        rModel.setMaximum(memento.getInteger("maximum").intValue());
        rModel.setExtent(memento.getInteger("extent").intValue());
        rModel.setValue(memento.getInteger("value").intValue());
        super.restoreState(memento);
    }

    public void saveState(IMemento memento) {
        memento.putString(PROPERTY_EXPANSION_STATE, new Boolean(this.isExpanded()).toString());
        memento.putString(PROPERTY_PINNED_STATE, new Boolean(this.isPinnedOpen()).toString());
        RangeModel rModel = this.getDrawerFigure().getScrollpane().getViewport().getVerticalRangeModel();
        memento.putInteger("minimum", rModel.getMinimum());
        memento.putInteger("maximum", rModel.getMaximum());
        memento.putInteger("extent", rModel.getExtent());
        memento.putInteger("value", rModel.getValue());
        super.saveState(memento);
    }

    public void setExpanded(boolean expanded) {
        this.getDrawerFigure().setExpanded(expanded);
    }

    protected void setImageInFigure(Image image) {
        this.getDrawerFigure().setTitleIcon(image);
    }

    public void setPinnedOpen(boolean pinned) {
        this.getDrawerFigure().setPinned(pinned);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        this.getDrawerFigure().getCollapseToggle().requestFocus();
    }

    protected void unregister() {
        this.getPaletteAnimator().removeDrawer(this);
        super.unregister();
    }
}

