/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Event;

public class EditDomain {
    private Tool defaultTool;
    private PaletteViewer paletteViewer;
    private PaletteRoot paletteRoot;
    private Tool activeTool;
    private List viewers = new ArrayList();
    private CommandStack commandStack = new CommandStack();
    private PaletteListener paletteListener = new PaletteListener(){

        public void activeToolChanged(PaletteViewer viewer, ToolEntry tool) {
            EditDomain.this.handlePaletteToolChanged();
        }
    };

    public EditDomain() {
        this.loadDefaultTool();
    }

    public void addViewer(EditPartViewer viewer) {
        viewer.setEditDomain(this);
        if (!this.viewers.contains(viewer)) {
            this.viewers.add(viewer);
        }
    }

    public void focusGained(FocusEvent event, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.focusGained(event, viewer);
        }
    }

    public void focusLost(FocusEvent event, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.focusLost(event, viewer);
        }
    }

    public Tool getActiveTool() {
        return this.activeTool;
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public Tool getDefaultTool() {
        if (this.defaultTool == null) {
            this.defaultTool = new SelectionTool();
        }
        return this.defaultTool;
    }

    public PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    private void handlePaletteToolChanged() {
        PaletteViewer paletteViewer = this.getPaletteViewer();
        if (paletteViewer != null) {
            ToolEntry entry = paletteViewer.getActiveTool();
            if (entry != null) {
                this.setActiveTool(entry.createTool());
            } else {
                this.setActiveTool(this.getDefaultTool());
            }
        }
    }

    public void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.keyDown(keyEvent, viewer);
        }
    }

    public void keyTraversed(TraverseEvent traverseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.keyTraversed(traverseEvent, viewer);
        }
    }

    public void keyUp(KeyEvent keyEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.keyUp(keyEvent, viewer);
        }
    }

    public void loadDefaultTool() {
        this.setActiveTool(null);
        PaletteViewer paletteViewer = this.getPaletteViewer();
        if (this.paletteRoot != null && paletteViewer != null) {
            if (this.paletteRoot.getDefaultEntry() != null) {
                paletteViewer.setActiveTool(this.paletteRoot.getDefaultEntry());
                return;
            }
            paletteViewer.setActiveTool(null);
        }
        this.setActiveTool(this.getDefaultTool());
    }

    public void mouseDoubleClick(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDoubleClick(mouseEvent, viewer);
        }
    }

    public void mouseDown(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDown(mouseEvent, viewer);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDrag(mouseEvent, viewer);
        }
    }

    public void mouseHover(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseHover(mouseEvent, viewer);
        }
    }

    public void mouseMove(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseMove(mouseEvent, viewer);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseUp(mouseEvent, viewer);
        }
    }

    public void mouseWheelScrolled(Event event, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseWheelScrolled(event, viewer);
        }
    }

    public void nativeDragFinished(DragSourceEvent event, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.nativeDragFinished(event, viewer);
        }
    }

    public void nativeDragStarted(DragSourceEvent event, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.nativeDragStarted(event, viewer);
        }
    }

    public void removeViewer(EditPartViewer viewer) {
        if (this.viewers.remove(viewer)) {
            viewer.setEditDomain(null);
        }
    }

    public void setCommandStack(CommandStack stack) {
        this.commandStack = stack;
    }

    public void setDefaultTool(Tool tool) {
        this.defaultTool = tool;
    }

    public void setPaletteRoot(PaletteRoot root) {
        if (this.paletteRoot == root) {
            return;
        }
        this.paletteRoot = root;
        if (this.getPaletteViewer() != null) {
            this.getPaletteViewer().setPaletteRoot(this.paletteRoot);
            this.loadDefaultTool();
        }
    }

    public void setPaletteViewer(PaletteViewer palette) {
        if (palette == this.paletteViewer) {
            return;
        }
        if (this.paletteViewer != null) {
            this.paletteViewer.removePaletteListener(this.paletteListener);
        }
        this.paletteViewer = palette;
        if (this.paletteViewer != null) {
            palette.addPaletteListener(this.paletteListener);
            if (this.paletteRoot != null) {
                this.paletteViewer.setPaletteRoot(this.paletteRoot);
                this.loadDefaultTool();
            }
        }
    }

    public void setActiveTool(Tool tool) {
        if (this.activeTool != null) {
            this.activeTool.deactivate();
        }
        this.activeTool = tool;
        if (this.activeTool != null) {
            this.activeTool.setEditDomain(this);
            this.activeTool.activate();
        }
    }

    public void viewerEntered(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.viewerEntered(mouseEvent, viewer);
        }
    }

    public void viewerExited(MouseEvent mouseEvent, EditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.viewerExited(mouseEvent, viewer);
        }
    }
}

