/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;

public class TaskDataExportOperation
implements IRunnableWithProgress {
    private static final String EXPORT_JOB_LABEL = Messages.TaskDataExportOperation_exporting_task_data;
    private static final Pattern excludePattern = Pattern.compile("(?:^\\.|^monitor-log.xml\\z|^tasklist.xml.zip\\z|attachments\\z|backup\\z)");
    private final String destinationDirectory;
    private final String destinationFilename;

    public TaskDataExportOperation(String destinationDirectory, String destinationFilename) {
        this.destinationFilename = destinationFilename;
        this.destinationDirectory = destinationDirectory;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        HashSet<File> filesToExport = new HashSet<File>();
        this.selectFiles(filesToExport);
        if (filesToExport.size() > 0 && Platform.isRunning()) {
            try {
                try {
                    monitor.beginTask(EXPORT_JOB_LABEL, filesToExport.size() + 1);
                    Job.getJobManager().beginRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ZipFileUtil.createZipFile((File)this.getDestinationFile(), new ArrayList<File>(filesToExport), (String)TasksUiPlugin.getDefault().getDataDirectory(), (IProgressMonitor)monitor);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                Job.getJobManager().endRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
                monitor.done();
            }
        }
    }

    public File getDestinationFile() {
        return new File(String.valueOf(this.destinationDirectory) + File.separator + this.destinationFilename);
    }

    protected void selectFiles(Set<File> filesToExport) {
        HashSet<Pattern> exclusionPatterns = new HashSet<Pattern>();
        exclusionPatterns.add(excludePattern);
        String dataRoot = TasksUiPlugin.getDefault().getDataDirectory();
        File dataFolder = new File(dataRoot);
        File[] fileArray = dataFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            boolean exclude = false;
            for (Pattern pattern : exclusionPatterns) {
                if (!pattern.matcher(file.getName()).find()) continue;
                exclude = true;
                break;
            }
            if (!exclude) {
                filesToExport.add(file);
            }
            ++n2;
        }
    }

    protected File getSourceFolder() {
        return new File(TasksUiPlugin.getDefault().getDataDirectory());
    }
}

