/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.WorkbenchImages;

public class CompareAttachmentsAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private ISelection currentSelection;
    private static final String[] IMAGE_EXTENSIONS = new String[]{".jpg", ".gif", ".png", ".tiff", ".tif", ".bmp"};

    public CompareAttachmentsAction() {
        super(Messages.CompareAttachmentsAction_Compare_Attachments);
    }

    protected CompareAttachmentsAction(String text) {
        super(text);
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        IStructuredSelection selection;
        Object[] elements;
        if (this.currentSelection instanceof IStructuredSelection && (elements = (selection = (IStructuredSelection)this.currentSelection).toArray()).length >= 2) {
            final ITaskAttachment attachment1 = (ITaskAttachment)elements[0];
            final ITaskAttachment attachment2 = (ITaskAttachment)elements[1];
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(false);
            cc.setLeftLabel(attachment1.getFileName());
            cc.setLeftImage(this.getImage(attachment1));
            cc.setRightEditable(false);
            cc.setRightLabel(attachment2.getFileName());
            cc.setRightImage(this.getImage(attachment2));
            CompareEditorInput editorInput = new CompareEditorInput(cc){

                public String getTitle() {
                    return String.valueOf(Messages.CompareAttachmentsAction_Compare__) + attachment1.getFileName() + " - " + attachment2.getFileName() + ")";
                }

                protected Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
                    CompareItem left = new CompareItem(attachment1);
                    CompareItem right = new CompareItem(attachment2);
                    return new DiffNode((ITypedElement)left, (ITypedElement)right);
                }
            };
            CompareUI.openCompareEditor((CompareEditorInput)editorInput);
        }
    }

    private Image getImage(ITaskAttachment attachment) {
        if (AttachmentUtil.isContext(attachment)) {
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_TRANSFER);
        }
        if (attachment.isPatch()) {
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_ATTACHMENT_PATCH);
        }
        String filename = attachment.getFileName();
        if (filename != null) {
            filename = filename.toLowerCase();
            String[] stringArray = IMAGE_EXTENSIONS;
            int n = IMAGE_EXTENSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (filename.endsWith(extension)) {
                    return CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_FILE);
                }
                ++n2;
            }
        }
        return WorkbenchImages.getImage((String)"IMG_OBJ_FILE");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    private class CompareItem
    implements IStreamContentAccessor,
    ITypedElement {
        private final ITaskAttachment attachment;

        public CompareItem(ITaskAttachment attachment) {
            this.attachment = attachment;
        }

        public InputStream getContents() throws CoreException {
            TaskAttribute attachmentAttribute = this.attachment.getTaskAttribute();
            if (attachmentAttribute == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", String.valueOf(Messages.CompareAttachmentsAction_Failed_to_find_attachment) + this.attachment.getUrl()));
            }
            TaskRepository taskRepository = this.attachment.getTaskRepository();
            ITask task = this.attachment.getTask();
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
            AbstractTaskAttachmentHandler handler = connector.getTaskAttachmentHandler();
            return handler.getContent(taskRepository, task, attachmentAttribute, (IProgressMonitor)new NullProgressMonitor());
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return this.attachment.getFileName();
        }

        public String getType() {
            String filename = this.attachment.getFileName();
            int n = filename.lastIndexOf(46);
            if (n > -1) {
                return filename.substring(n + 1);
            }
            return "txt";
        }
    }
}

