/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.internal.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCorePlugin;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;

public class ProxiesResolveConstraint
extends AbstractModelConstraint {
    public static final String RESOURCE_RULE_ID = "org.eclipse.gmf.runtime.emf.core.ResourceFixup";
    public static final String ELEMENT_RULE_ID = "org.eclipse.gmf.runtime.emf.core.IdFixup";
    public static final String DIAGNOSTIC_SOURCE = EMFCorePlugin.getPluginId();

    private String getObjectLabel(EObject eObject) {
        return EMFCoreUtil.getQualifiedName(eObject, true);
    }

    private String getFeatureLabel(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getName();
    }

    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        EStructuralFeature feature = null;
        EObject proxyObject = null;
        EContentsEList.FeatureIterator i = (EContentsEList.FeatureIterator)target.eCrossReferences().iterator();
        while (i.hasNext()) {
            EObject eCrossReferenceObject = (EObject)i.next();
            if (i.feature().isDerived() || !eCrossReferenceObject.eIsProxy()) continue;
            feature = i.feature();
            proxyObject = eCrossReferenceObject;
            ctx.addResult(proxyObject);
            break;
        }
        if (feature != null) {
            URI proxyURI;
            ResourceSet rSet = target.eResource().getResourceSet();
            Resource resource = rSet.getResource(proxyURI = ((InternalEObject)proxyObject).eProxyURI().trimFragment(), false);
            if (resource != null && resource.isLoaded()) {
                if (ctx.getCurrentConstraintId().equals(ELEMENT_RULE_ID)) {
                    return ctx.createFailureStatus(new Object[]{this.getFeatureLabel(feature), this.getObjectLabel(target), this.getObjectLabel(proxyObject)});
                }
                return ctx.createSuccessStatus();
            }
            if (ctx.getCurrentConstraintId().equals(RESOURCE_RULE_ID)) {
                return ctx.createFailureStatus(new Object[]{this.getFeatureLabel(feature), this.getObjectLabel(target), this.getObjectLabel(proxyObject)});
            }
        }
        return ctx.createSuccessStatus();
    }
}

