/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.resource.FileStoreStorage;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperContribution;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperExtension;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class Storage2UriMapperImpl
implements IStorage2UriMapperExtension {
    private static final Logger log = Logger.getLogger(Storage2UriMapperImpl.class);
    @Inject
    private UriValidator uriValidator;
    private IStorage2UriMapperContribution contribution = new IStorage2UriMapperContribution(){

        @Override
        public void initializeCache() {
        }

        @Override
        public boolean isRejected(IFolder folder) {
            return false;
        }

        @Override
        public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
            return Collections.emptyList();
        }

        @Override
        public URI getUri(IStorage storage) {
            return null;
        }
    };

    public final void setUriValidator(UriValidator uriValidator) {
        this.uriValidator = uriValidator;
    }

    public void setContribution(IStorage2UriMapperContribution contribution) {
        this.contribution = contribution;
    }

    public IStorage2UriMapperContribution getContribution() {
        return this.contribution;
    }

    @Inject
    private void initializeContributions(ISharedStateContributionRegistry registry) {
        final ImmutableList<IStorage2UriMapperContribution> allContributions = registry.getContributedInstances(IStorage2UriMapperContribution.class);
        final int size = allContributions.size();
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                this.contribution = (IStorage2UriMapperContribution)allContributions.get(0);
                break;
            }
            default: {
                this.contribution = new IStorage2UriMapperContribution(){

                    @Override
                    public void initializeCache() {
                        for (IStorage2UriMapperContribution contribution : allContributions) {
                            contribution.initializeCache();
                        }
                    }

                    @Override
                    public boolean isRejected(IFolder folder) {
                        int i = 0;
                        while (i < size) {
                            if (((IStorage2UriMapperContribution)allContributions.get(i)).isRejected(folder)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }

                    @Override
                    public Iterable<Pair<IStorage, IProject>> getStorages(final URI uri) {
                        return Iterables.concat((Iterable)Lists.transform((List)allContributions, (Function)new Function<IStorage2UriMapperContribution, Iterable<Pair<IStorage, IProject>>>(){

                            public Iterable<Pair<IStorage, IProject>> apply(IStorage2UriMapperContribution contribution) {
                                return contribution.getStorages(uri);
                            }
                        }));
                    }

                    @Override
                    public URI getUri(IStorage storage) {
                        int i = 0;
                        while (i < size) {
                            URI result = ((IStorage2UriMapperContribution)allContributions.get(i)).getUri(storage);
                            if (result != null) {
                                return result;
                            }
                            ++i;
                        }
                        return null;
                    }
                };
            }
        }
    }

    @Override
    public void initializeCache() {
        this.contribution.initializeCache();
    }

    @Override
    public Map<URI, IStorage> getAllEntries(IContainer container) {
        final LinkedHashMap result = Maps.newLinkedHashMap();
        try {
            container.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFile storage;
                    URI uri;
                    if (resource instanceof IFile && (uri = Storage2UriMapperImpl.this.getUri((IStorage)(storage = (IFile)resource))) != null) {
                        result.put(uri, storage);
                    }
                    if (resource instanceof IFolder) {
                        return Storage2UriMapperImpl.this.isHandled((IFolder)resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected boolean isHandled(IFolder folder) {
        return !this.contribution.isRejected(folder);
    }

    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        if (!uri.isPlatformResource()) {
            Path path;
            if (uri.isFile() && (path = new Path(uri.toFileString())).isAbsolute()) {
                IFile file = this.getWorkspaceRoot().getFileForLocation((IPath)path);
                return this.getStorages(uri, file);
            }
            return this.contribution.getStorages(uri);
        }
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        return this.getStorages(uri, file);
    }

    private Iterable<Pair<IStorage, IProject>> getStorages(URI uri, IFile file) {
        if (file == null || !file.isAccessible()) {
            Iterable<Pair<IStorage, IProject>> result = this.contribution.getStorages(uri);
            if ((result == null || !result.iterator().hasNext()) && uri.isFile()) {
                Path filePath = new Path(uri.toFileString());
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)filePath);
                IFileInfo fileInfo = fileStore.fetchInfo();
                if (fileInfo.exists() && !fileInfo.isDirectory()) {
                    return Collections.singletonList(Tuples.create((Object)new FileStoreStorage(fileStore, fileInfo, filePath), null));
                }
            }
            return result;
        }
        return Collections.singleton(Tuples.create((Object)file, (Object)file.getProject()));
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public URI getUri(IStorage storage) {
        if (!this.uriValidator.isPossiblyManaged(storage)) {
            return null;
        }
        URI uri = this.internalGetUri(storage);
        if (uri != null && this.isValidUri(uri, storage)) {
            return uri;
        }
        return null;
    }

    private URI internalGetUri(IStorage storage) {
        if (storage instanceof IFile) {
            return URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        }
        if (storage instanceof FileStoreStorage) {
            return URI.createFileURI((String)((FileStoreStorage)storage).getFullPath().makeAbsolute().toOSString());
        }
        return this.contribution.getUri(storage);
    }

    public boolean isValidUri(URI uri, IStorage storage) {
        boolean valid = this.uriValidator.isValid(uri, storage);
        return valid;
    }
}

