/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist.antlr;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentAssistContextFactory;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.antlr.DelegatingContentAssistContextFactory;

@Singleton
public class DelegatingContentAssistContextFactoryWithSharedPool
extends AbstractContentAssistContextFactory {
    private final Provider<DelegatingContentAssistContextFactory.StatefulFactory> statefulFactoryProvider;
    private final ExecutorService pool;

    @Inject
    public DelegatingContentAssistContextFactoryWithSharedPool(Provider<DelegatingContentAssistContextFactory.StatefulFactory> statefulFactoryProvider, SharedExecutorServiceAccess access) {
        this.pool = access.pool();
        this.statefulFactoryProvider = statefulFactoryProvider;
    }

    public Provider<? extends DelegatingContentAssistContextFactory.StatefulFactory> getStatefulFactoryProvider() {
        return this.statefulFactoryProvider;
    }

    protected ExecutorService getPool() {
        return this.pool;
    }

    @Override
    public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
        DelegatingContentAssistContextFactory.StatefulFactory factory = (DelegatingContentAssistContextFactory.StatefulFactory)this.getStatefulFactoryProvider().get();
        factory.setPool(this.pool);
        return factory.create(viewer, offset, resource);
    }

    @Singleton
    public static class SharedExecutorServiceAccess {
        ExecutorService pool = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("ContentAssistContextFactorySharedPool-%d").build());

        ExecutorService pool() {
            return this.pool;
        }
    }
}

