/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class UnlockObjectsRequest
extends CDOClientRequest<CDOSessionProtocol.UnlockObjectsResult> {
    private int viewID;
    private Collection<CDOID> objectIDs;
    private IRWLockManager.LockType lockType;
    private boolean recursive;

    public UnlockObjectsRequest(CDOClientProtocol protocol, int viewID, Collection<CDOID> objects, IRWLockManager.LockType lockType, boolean recursive) {
        this(protocol, 25, viewID, objects, lockType, recursive);
    }

    protected UnlockObjectsRequest(CDOClientProtocol protocol, short signalID, int viewID, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType, boolean recursive) {
        super(protocol, signalID);
        this.viewID = viewID;
        this.objectIDs = objectIDs;
        this.lockType = lockType;
        this.recursive = recursive;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.viewID);
        out.writeCDOLockType(this.lockType);
        out.writeBoolean(this.recursive);
        if (this.objectIDs == null) {
            out.writeXInt(-1);
        } else {
            out.writeXInt(this.objectIDs.size());
            for (CDOID id : this.objectIDs) {
                out.writeCDOID(id);
            }
        }
    }

    @Override
    protected CDOSessionProtocol.UnlockObjectsResult confirming(CDODataInput in) throws IOException {
        long timestamp = in.readXLong();
        List lockDeltas = in.readCDOLockDeltas();
        List lockStates = in.readCDOLockStates();
        return new CDOSessionProtocol.UnlockObjectsResult(timestamp, lockDeltas, lockStates);
    }

    protected String getAdditionalInfo() {
        return "viewID=" + this.viewID + ", lockType=" + this.lockType + ", objectIDs=" + this.objectIDs + ", recursive=" + this.recursive;
    }
}

