/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileAttributes;
import org.eclipse.ecf.filetransfer.IRemoteFileInfo;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFileAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLRemoteFile
implements IRemoteFile {
    IFileID fileID;
    long lastModified;
    long fileLength;
    IRemoteFileAttributes remoteFileAttributes;

    public URLRemoteFile(long lastModified, long fileLength, IFileID fileID) {
        this.lastModified = lastModified;
        this.fileLength = fileLength;
        Assert.isNotNull((Object)fileID);
        this.fileID = fileID;
        this.remoteFileAttributes = new URLRemoteFileAttributes();
    }

    public IFileID getID() {
        return this.fileID;
    }

    public IRemoteFileInfo getInfo() {
        return new IRemoteFileInfo(){

            public IRemoteFileAttributes getAttributes() {
                return URLRemoteFile.this.remoteFileAttributes;
            }

            public long getLastModified() {
                return URLRemoteFile.this.lastModified;
            }

            public long getLength() {
                return URLRemoteFile.this.fileLength;
            }

            public String getName() {
                String result = null;
                try {
                    URL url = URLRemoteFile.this.fileID.getURL();
                    String path = url.getPath();
                    int index = path.lastIndexOf("/");
                    if (index == -1) {
                        return path;
                    }
                    result = path.substring(index + 1);
                    return result;
                }
                catch (MalformedURLException e) {
                    return URLRemoteFile.this.fileID.getName();
                }
            }

            public boolean isDirectory() {
                try {
                    return URLRemoteFile.this.fileID.getURL().toString().endsWith("/");
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }

            public void setAttributes(IRemoteFileAttributes attributes) {
            }

            public void setLastModified(long time) {
            }

            public void setName(String name) {
            }
        };
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return adapter.cast(this);
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return (T)adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("URLRemoteFile[");
        buf.append("id=").append(this.getID()).append(";");
        buf.append("name=").append(this.getInfo().getName()).append(";");
        buf.append("isDir=").append(this.getInfo().isDirectory()).append(";");
        buf.append("length=").append(this.getInfo().getLength()).append(";");
        buf.append("lastMod=").append(this.getInfo().getLastModified()).append(";");
        buf.append("attr=").append(this.getInfo().getAttributes()).append("]");
        return buf.toString();
    }
}

