/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.common.internal.command.DefaultTableCreationCommand;
import org.eclipse.papyrus.infra.nattable.common.internal.command.ITableCreationCommand;
import org.eclipse.papyrus.infra.nattable.common.utils.TableUtil;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.nattable.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.AbstractViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableCommandHelper
extends AbstractViewTypeHelper<PapyrusTable> {
    public TableCommandHelper() {
        super(PapyrusTable.class);
    }

    public boolean isSupported(EClass type) {
        return type == RepresentationPackage.eINSTANCE.getPapyrusTable();
    }

    public boolean isSupported(EObject view) {
        if (!(view instanceof Table)) {
            return false;
        }
        Table table = (Table)view;
        return table.getTableKindId() != null || table.getTableConfiguration() != null;
    }

    protected ViewPrototype doGetPrototypeFor(PapyrusTable papyrusTable) {
        String commandClassName = papyrusTable.getCreationCommand();
        if (commandClassName != null) {
            Class creationCommandClass = ClassLoaderHelper.loadClass((String)commandClassName, ITableCreationCommand.class, (URI)EcoreUtil.getURI((EObject)papyrusTable));
            if (creationCommandClass != null) {
                ITableCreationCommand command;
                try {
                    command = (ITableCreationCommand)creationCommandClass.newInstance();
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
                return new TableViewPrototype(papyrusTable, command);
            }
            Activator.log.error((Throwable)new ClassNotFoundException(String.format("Can not load creation command class %s for tableType %s.", commandClassName, papyrusTable.getName())));
        }
        return new TableViewPrototype(papyrusTable, new DefaultTableCreationCommand());
    }

    protected ViewPrototype doGetPrototypeOf(EObject view) {
        return TableUtil.getPrototype((Table)view, false);
    }
}

