/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.internal.core.PDECore;

public class WorkspaceBaseline
extends ApiBaseline {
    public Map<IApiBaseline, IApiProblem> mismatch = new ConcurrentHashMap<IApiBaseline, IApiProblem>();
    private static final IApiProblem NULL_PROBLEM = (IApiProblem)Proxy.newProxyInstance(IApiProblem.class.getClassLoader(), new Class[]{IApiProblem.class}, (proxy, method, args) -> null);

    public WorkspaceBaseline() {
        super("workspace");
    }

    @Override
    public void dispose() {
        this.doDispose();
        this.mismatch.clear();
    }

    @Override
    public State getState() {
        return PDECore.getDefault().getModelManager().getState().getState();
    }

    public boolean containsBaseline(IApiBaseline b) {
        return this.mismatch.containsKey(b);
    }

    public IApiProblem getProblem(IApiBaseline b) {
        IApiProblem problem = this.mismatch.get(b);
        return problem == NULL_PROBLEM ? null : problem;
    }

    public void putMismatchInfo(IApiBaseline baseline, IApiProblem problem) {
        if (problem == null) {
            this.mismatch.put(baseline, NULL_PROBLEM);
        } else {
            this.mismatch.put(baseline, problem);
        }
    }

    @Override
    public void addApiComponents(IApiComponent[] components) throws CoreException {
        if (this.isDisposed()) {
            return;
        }
        HashSet<String> ees = new HashSet<String>();
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent apiComponent = iApiComponentArray[n2];
            BundleComponent component = (BundleComponent)apiComponent;
            if (!component.isSourceComponent()) {
                this.addComponent(component);
                ees.addAll(Arrays.asList(component.getExecutionEnvironments()));
            }
            ++n2;
        }
        this.resolveSystemLibrary(ees);
    }
}

