/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.BundleJarFiles;
import org.eclipse.pde.api.tools.internal.BundleListTargetLocation;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.osgi.framework.Bundle;

public class ApiAnalysisApplication
implements IApplication {
    private ICoreRunnable restoreOriginalProjectState = null;

    public Object start(IApplicationContext context) throws Exception {
        this.restoreOriginalProjectState = null;
        try {
            IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
            desc.setAutoBuilding(false);
            ResourcesPlugin.getWorkspace().setDescription(desc);
            PDECore.getDefault().getPreferencesManager().setValue("Preferences.MainPage.disableAPIAnalysisBuilder", false);
            PDECore.getDefault().getPreferencesManager().setValue("Preferences.MainPage.runAPIAnalysisAsJob", false);
            Request args = Request.readFromArgs((String[])context.getArguments().get("application.args"));
            IProject project = this.importProject(args.project);
            if (project == null) {
                System.err.println("Project not loaded.");
                Integer n = 4;
                return n;
            }
            IApiBaseline baseline = this.setBaseline(args.baselinePath);
            if (baseline == null) {
                System.err.println("Baseline shouldn't be null.");
                Integer n = 4;
                return n;
            }
            this.setTargetPlatform(args.tpFile);
            this.configureSeverity(project);
            project.build(6, (IProgressMonitor)new NullProgressMonitor());
            IMarker[] allProblemMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            Predicate<IMarker> isAPIMarker = marker -> {
                try {
                    return marker.getType().startsWith("org.eclipse.pde.api.tools");
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                    return false;
                }
            };
            IMarker[] allAPIProbleMarkers = (IMarker[])Arrays.stream(allProblemMarkers).filter(isAPIMarker).toArray(IMarker[]::new);
            IMarker[] allNonAPIErrors = (IMarker[])Arrays.stream(allProblemMarkers).filter(isAPIMarker.negate()).filter(marker -> marker.getAttribute("severity", -1) == 2).toArray(IMarker[]::new);
            if (allNonAPIErrors.length > 0) {
                System.err.println("Some blocking (most likely link/compilation) errors are present:");
                IMarker[] iMarkerArray = allNonAPIErrors;
                int n = allNonAPIErrors.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker2 = iMarkerArray[n2];
                    System.err.println("* " + marker2);
                    ++n2;
                }
                System.err.println("Some blocking (most likely link/compilation) errors are present ^^^");
                Integer n3 = 10;
                return n3;
            }
            IMarker[] errorMarkers = (IMarker[])Arrays.stream(allAPIProbleMarkers).filter(marker -> marker.getAttribute("severity", -1) == 2).toArray(IMarker[]::new);
            System.err.println(String.valueOf(errorMarkers.length) + " API ERRORS");
            IMarker[] iMarkerArray = errorMarkers;
            int n = errorMarkers.length;
            int n4 = 0;
            while (n4 < n) {
                IMarker marker3 = iMarkerArray[n4];
                System.err.println("* " + marker3);
                ++n4;
            }
            IMarker[] warningMarkers = (IMarker[])Arrays.stream(allAPIProbleMarkers).filter(marker -> marker.getAttribute("severity", -1) == 1).toArray(IMarker[]::new);
            System.out.println(String.valueOf(warningMarkers.length) + " API warnings");
            IMarker[] iMarkerArray2 = warningMarkers;
            int n5 = warningMarkers.length;
            n = 0;
            while (n < n5) {
                IMarker marker4 = iMarkerArray2[n];
                System.out.println("* " + marker4);
                ++n;
            }
            if (args.failOnError && errorMarkers.length > 0) {
                Integer n6 = 4;
                return n6;
            }
            Integer n7 = 0;
            return n7;
        }
        catch (CoreException e) {
            System.err.println(e.getStatus());
            Integer n = 4;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            Integer n = 4;
            return n;
        }
        finally {
            if (this.restoreOriginalProjectState != null) {
                this.restoreOriginalProjectState.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private void setTargetPlatform(File dependencyList) throws IOException, CoreException, InterruptedException {
        if (dependencyList != null) {
            if (!dependencyList.isFile() || !dependencyList.canRead()) {
                throw new IllegalArgumentException("dependencyList argument points to non readable file: " + dependencyList.getAbsolutePath());
            }
            ITargetPlatformService service = TargetPlatformService.getDefault();
            ITargetDefinition target = service.newTarget();
            target.setName("buildpath");
            TargetBundle[] bundles = (TargetBundle[])new BundleJarFiles(dependencyList).list().stream().map(absoluteFile -> {
                try {
                    return new TargetBundle(absoluteFile);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                    return null;
                }
            }).filter(Objects::nonNull).toArray(TargetBundle[]::new);
            target.setTargetLocations(new ITargetLocation[]{new BundleListTargetLocation(bundles)});
            service.saveTargetDefinition(target);
            LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
            job.schedule();
            job.join();
        }
    }

    protected void configureSeverity(IProject project) {
        HashMap<String, String> enforcedSeverities = new HashMap<String, String>();
        enforcedSeverities.put("incompatible_api_component_version_report_major_without_breaking_change", "Error");
        enforcedSeverities.put("incompatible_api_component_version_report_minor_without_api_change", "Error");
        IEclipsePreferences projectNode = new ProjectScope(project).getNode("org.eclipse.pde.api.tools");
        enforcedSeverities.forEach((key, value) -> {
            PDECore.getDefault().getPreferencesManager().setValue(key, value);
            projectNode.put(key, value);
        });
    }

    private IApiBaseline setBaseline(File baselinePath) throws CoreException {
        if (baselinePath == null) {
            ApiBaseline baseline = new ApiBaseline("current running application");
            Bundle[] bundleArray = ApiPlugin.getDefault().getBundle().getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getBundleId() != 0L) {
                    String bundleFile = ((File)FileLocator.getBundleFileLocation((Bundle)bundle).orElseThrow()).getAbsolutePath();
                    baseline.addApiComponents(new IApiComponent[]{new BundleComponent(baseline, bundleFile, bundle.getBundleId())});
                }
                ++n2;
            }
            ApiBaselineManager.getManager().addApiBaseline(baseline);
            ApiBaselineManager.getManager().setDefaultApiBaseline(baseline.getName());
            return baseline;
        }
        String baselineFileName = baselinePath.getName();
        if (baselinePath.isFile() && baselineFileName.endsWith(".target")) {
            ITargetPlatformService service = TargetPlatformService.getDefault();
            ITargetDefinition definition = service.getTarget(baselinePath.toURI()).getTargetDefinition();
            IStatus resolutionStatus = definition.resolve((IProgressMonitor)new NullProgressMonitor());
            switch (resolutionStatus.getSeverity()) {
                case 2: {
                    System.out.println("WARNING resolving target platform: " + resolutionStatus.getMessage());
                    break;
                }
                case 4: {
                    throw new CoreException(resolutionStatus);
                }
            }
            String baselineName = baselineFileName.substring(0, baselineFileName.lastIndexOf(46));
            ApiBaseline baseline = new ApiBaseline(baselineName);
            TargetBundle[] targetBundleArray = definition.getAllBundles();
            int n = targetBundleArray.length;
            int n3 = 0;
            while (n3 < n) {
                TargetBundle bundle = targetBundleArray[n3];
                BundleInfo bundleInfo = bundle.getBundleInfo();
                if (bundleInfo.getBundleId() != 0L) {
                    baseline.addApiComponents(new IApiComponent[]{new BundleComponent(baseline, new File(bundleInfo.getLocation()).getAbsolutePath(), bundleInfo.getBundleId())});
                }
                ++n3;
            }
            ApiBaselineManager.getManager().addApiBaseline(baseline);
            ApiBaselineManager.getManager().setDefaultApiBaseline(baseline.getName());
            return baseline;
        }
        if (baselinePath.isDirectory()) {
            System.err.println("Support for directories not implemented yet, use `default` or a `</path/to/baseline.target>` baseline for currently running application.");
            return null;
        }
        return ApiBaselineManager.getManager().getDefaultApiBaseline();
    }

    private IProject importProject(File projectPath) throws CoreException, IOException {
        Object[] newBuilders;
        ICoreRunnable projectRemover;
        File dotProject = new File(projectPath, ".project");
        if (!dotProject.isFile()) {
            System.err.println("Expected `" + dotProject.getAbsolutePath() + "` file doesn't exist.");
            return null;
        }
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(Path.fromOSString((String)dotProject.getAbsolutePath()));
        projectDescription.setLocation(Path.fromOSString((String)projectPath.getAbsolutePath()));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectDescription.getName());
        if (project.exists()) {
            projectRemover = !project.isOpen() ? arg_0 -> ((IProject)project).close(arg_0) : m -> {};
            project.open((IProgressMonitor)new NullProgressMonitor());
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            if (!project.getDescription().getLocationURI().equals(projectDescription.getLocationURI())) {
                System.err.println("Project with same name and different location exists in workspace.");
                return null;
            }
        } else {
            projectRemover = m -> project.delete(9, m);
            project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        projectDescription = project.getDescription();
        ICommand[] buildSpec = projectDescription.getBuildSpec();
        if (Arrays.stream(buildSpec).map(ICommand::getBuilderName).noneMatch("org.eclipse.pde.api.tools.apiAnalysisBuilder"::equals)) {
            ICommand apiAnalysisBuilderCommand = projectDescription.newCommand();
            apiAnalysisBuilderCommand.setBuilderName("org.eclipse.pde.api.tools.apiAnalysisBuilder");
            ICommand[] builders = new ICommand[buildSpec.length + 1];
            System.arraycopy(buildSpec, 0, builders, 0, buildSpec.length);
            builders[builders.length - 1] = apiAnalysisBuilderCommand;
            buildSpec = builders;
        }
        if (!Arrays.equals(newBuilders = ApiAnalysisApplication.removeManifestAndSchemaBuilders(buildSpec), projectDescription.getBuildSpec())) {
            byte[] originalContent;
            IFile projectFile = project.getFile(".project");
            Throwable throwable = null;
            Object var13_11 = null;
            try (InputStream contentStream = projectFile.getContents();){
                originalContent = contentStream.readAllBytes();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            projectDescription.setBuildSpec((ICommand[])newBuilders);
            project.setDescription(projectDescription, 0, (IProgressMonitor)new NullProgressMonitor());
            this.restoreOriginalProjectState = m -> {
                projectFile.setContents((InputStream)new ByteArrayInputStream(originalContent), 1, m);
                projectRemover.run(m);
            };
        } else {
            this.restoreOriginalProjectState = projectRemover;
        }
        return project;
    }

    private static ICommand[] removeManifestAndSchemaBuilders(ICommand[] buildSpec) {
        return (ICommand[])Arrays.stream(buildSpec).filter(x -> !"org.eclipse.pde.ManifestBuilder".equals(x.getBuilderName()) && !"org.eclipse.pde.SchemaBuilder".equals(x.getBuilderName())).toArray(ICommand[]::new);
    }

    public void stop() {
    }

    private static class Request {
        private static final String FAIL_ON_ERROR_ARG = "failOnError";
        private static final String PROJECT_ARG = "project";
        private static final String BASELINE_ARG = "baseline";
        private static final String BASELINE_DEFAULT_VALUE = "default";
        private static final String DEPENDENCY_LIST_ARG = "dependencyList";
        public File project;
        public File baselinePath;
        public boolean failOnError;
        public File tpFile;

        private Request() {
        }

        public static Request readFromArgs(String[] params) {
            Request res = new Request();
            String currentKey = null;
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if (param.charAt(0) == '-') {
                    if (FAIL_ON_ERROR_ARG.equals(currentKey)) {
                        res.failOnError = true;
                    }
                    currentKey = param.substring(1);
                } else if (PROJECT_ARG.equals(currentKey)) {
                    res.project = new File(param);
                } else if (BASELINE_ARG.equals(currentKey) && !BASELINE_DEFAULT_VALUE.equals(param)) {
                    res.baselinePath = new File(param);
                } else if (FAIL_ON_ERROR_ARG.equals(currentKey)) {
                    res.failOnError = Boolean.parseBoolean(param);
                } else if (DEPENDENCY_LIST_ARG.equals(currentKey)) {
                    res.tpFile = new File(param);
                }
                ++n2;
            }
            if (FAIL_ON_ERROR_ARG.equals(currentKey)) {
                res.failOnError = true;
            }
            return res;
        }
    }
}

