/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.http.servlet.dto.ExtendedServletDTO;
import org.eclipse.equinox.http.servlet.internal.dto.ExtendedErrorPageDTO;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.util.ServiceProperties;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.dto.DTO;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedPreprocessorDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;

public class DTOUtil {
    public static ExtendedErrorPageDTO assembleErrorPageDTO(ServiceReference<?> serviceReference, long contextId, boolean validated) {
        List<String> errorPages;
        Object errorPageObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.errorPage");
        if (errorPageObj == null) {
            return null;
        }
        ExtendedErrorPageDTO errorPageDTO = new ExtendedErrorPageDTO();
        errorPageDTO.asyncSupported = false;
        Object asyncSupportedObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.asyncSupported");
        if (asyncSupportedObj != null) {
            if (Boolean.class.isInstance(asyncSupportedObj)) {
                errorPageDTO.asyncSupported = (Boolean)asyncSupportedObj;
            } else if (String.class.isInstance(asyncSupportedObj)) {
                errorPageDTO.asyncSupported = Boolean.valueOf((String)asyncSupportedObj);
            }
        }
        if ((errorPages = StringPlus.from(errorPageObj)).isEmpty()) {
            throw new HttpWhiteboardFailureException("'errorPage' expects String, String[] or Collection<String>", 6);
        }
        ArrayList<String> exceptions = new ArrayList<String>();
        LinkedHashSet<Long> errorCodeSet = new LinkedHashSet<Long>();
        for (String errorPage : errorPages) {
            try {
                long code;
                if ("4xx".equals(errorPage)) {
                    errorPageDTO.errorCodeType = ExtendedErrorPageDTO.ErrorCodeType.RANGE_4XX;
                    code = 400L;
                    while (code < 500L) {
                        errorCodeSet.add(code);
                        ++code;
                    }
                    continue;
                }
                if ("5xx".equals(errorPage)) {
                    errorPageDTO.errorCodeType = ExtendedErrorPageDTO.ErrorCodeType.RANGE_5XX;
                    code = 500L;
                    while (code < 600L) {
                        errorCodeSet.add(code);
                        ++code;
                    }
                    continue;
                }
                if (errorPage.matches("\\d{3}")) {
                    errorPageDTO.errorCodeType = ExtendedErrorPageDTO.ErrorCodeType.SPECIFIC;
                    code = Long.parseLong(errorPage);
                    errorCodeSet.add(code);
                    continue;
                }
                exceptions.add(errorPage);
            }
            catch (NumberFormatException numberFormatException) {
                exceptions.add(errorPage);
            }
        }
        errorPageDTO.errorCodes = new long[errorCodeSet.size()];
        int i = 0;
        for (Long code : errorCodeSet) {
            errorPageDTO.errorCodes[i] = code;
            ++i;
        }
        errorPageDTO.exceptions = exceptions.toArray(new String[0]);
        errorPageDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "servlet.init.");
        Object servletNameObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.name");
        if (servletNameObj != null) {
            if (String.class.isInstance(servletNameObj)) {
                errorPageDTO.name = (String)servletNameObj;
            } else if (validated) {
                throw new HttpWhiteboardFailureException("'name' expects String", 6);
            }
        }
        errorPageDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        errorPageDTO.servletContextId = contextId;
        return errorPageDTO;
    }

    public static ExtendedServletDTO assembleServletDTO(ServiceReference<?> serviceReference, long contextId, boolean validated) {
        Object patternObj;
        Object servletNameObj;
        ExtendedServletDTO servletDTO = new ExtendedServletDTO();
        servletDTO.asyncSupported = false;
        Object asyncSupportedObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.asyncSupported");
        if (asyncSupportedObj != null) {
            if (Boolean.class.isInstance(asyncSupportedObj)) {
                servletDTO.asyncSupported = (Boolean)asyncSupportedObj;
            } else if (String.class.isInstance(asyncSupportedObj)) {
                servletDTO.asyncSupported = Boolean.valueOf((String)asyncSupportedObj);
            }
        }
        servletDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "servlet.init.");
        servletDTO.multipartEnabled = false;
        Object multipartEnabledObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.multipart.enabled");
        if (multipartEnabledObj == null) {
            multipartEnabledObj = serviceReference.getProperty("equinox.http.multipartSupported");
        }
        if (multipartEnabledObj != null) {
            if (Boolean.class.isInstance(multipartEnabledObj)) {
                servletDTO.multipartEnabled = (Boolean)multipartEnabledObj;
            } else if (String.class.isInstance(multipartEnabledObj)) {
                servletDTO.multipartEnabled = Boolean.valueOf((String)multipartEnabledObj);
            }
        }
        servletDTO.multipartFileSizeThreshold = 0;
        servletDTO.multipartLocation = "";
        servletDTO.multipartMaxFileSize = -1L;
        servletDTO.multipartMaxRequestSize = -1L;
        if (servletDTO.multipartEnabled) {
            Object multipartMaxRequestSizeObj;
            Object multipartMaxFileSizeObj;
            Object multipartLocationObj;
            Object multipartFileSizeThresholdObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.multipart.fileSizeThreshold");
            if (multipartFileSizeThresholdObj == null) {
                multipartFileSizeThresholdObj = serviceReference.getProperty("equinox.http.whiteboard.servlet.multipart.fileSizeThreshold");
            }
            if (multipartFileSizeThresholdObj != null) {
                if (Integer.class.isInstance(multipartFileSizeThresholdObj)) {
                    servletDTO.multipartFileSizeThreshold = (Integer)multipartFileSizeThresholdObj;
                } else if (validated) {
                    throw new HttpWhiteboardFailureException("'multipartFileSizeThreshold' expects int or Integer", 6);
                }
            }
            if ((multipartLocationObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.multipart.location")) == null) {
                multipartLocationObj = serviceReference.getProperty("equinox.http.whiteboard.servlet.multipart.location");
            }
            if (multipartLocationObj != null) {
                if (String.class.isInstance(multipartLocationObj)) {
                    servletDTO.multipartLocation = (String)multipartLocationObj;
                } else if (validated) {
                    throw new HttpWhiteboardFailureException("'multipartLocation' expects String", 6);
                }
            }
            if ((multipartMaxFileSizeObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.multipart.maxFileSize")) == null) {
                multipartMaxFileSizeObj = serviceReference.getProperty("equinox.http.whiteboard.servlet.multipart.maxFileSize");
            }
            if (multipartMaxFileSizeObj != null) {
                if (Long.class.isInstance(multipartMaxFileSizeObj)) {
                    servletDTO.multipartMaxFileSize = (Long)multipartMaxFileSizeObj;
                } else if (validated) {
                    throw new HttpWhiteboardFailureException("'multipartMaxFileSize' expects [L|l]ong", 6);
                }
            }
            if ((multipartMaxRequestSizeObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.multipart.maxRequestSize")) == null) {
                multipartMaxRequestSizeObj = serviceReference.getProperty("equinox.http.whiteboard.servlet.multipart.maxRequestSize");
            }
            if (multipartMaxRequestSizeObj != null) {
                if (Long.class.isInstance(multipartMaxRequestSizeObj)) {
                    servletDTO.multipartMaxRequestSize = (Long)multipartMaxRequestSizeObj;
                } else if (validated) {
                    throw new HttpWhiteboardFailureException("'multipartMaxRequestSize' expects [L|l]ong", 6);
                }
            }
        }
        if ((servletNameObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.name")) != null) {
            if (String.class.isInstance(servletNameObj)) {
                servletDTO.name = (String)servletNameObj;
            } else if (validated) {
                throw new HttpWhiteboardFailureException("'name' expects String", 6);
            }
        }
        if ((patternObj = serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern")) == null) {
            servletDTO.patterns = new String[0];
        } else {
            servletDTO.patterns = DTOUtil.sort(StringPlus.from(patternObj).toArray(new String[0]));
            if (validated && servletDTO.patterns.length > 0) {
                String[] stringArray = servletDTO.patterns;
                int n = servletDTO.patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    DTOUtil.checkPattern(pattern);
                    ++n2;
                }
            }
        }
        servletDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        servletDTO.servletContextId = contextId;
        return servletDTO;
    }

    public static ErrorPageDTO clone(ErrorPageDTO original) {
        ErrorPageDTO clone = new ErrorPageDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.errorCodes = DTOUtil.copy(original.errorCodes);
        clone.exceptions = DTOUtil.copy(original.exceptions);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletInfo = DTOUtil.copy(original.servletInfo);
        return clone;
    }

    public static FailedErrorPageDTO clone(FailedErrorPageDTO original) {
        FailedErrorPageDTO clone = new FailedErrorPageDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.errorCodes = DTOUtil.copy(original.errorCodes);
        clone.exceptions = DTOUtil.copy(original.exceptions);
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletInfo = DTOUtil.copy(original.servletInfo);
        return clone;
    }

    public static FailedFilterDTO clone(FailedFilterDTO original) {
        FailedFilterDTO clone = new FailedFilterDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.dispatcher = DTOUtil.copy(original.dispatcher);
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.regexs = DTOUtil.copy(original.regexs);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletNames = DTOUtil.copy(original.servletNames);
        return clone;
    }

    public static FailedListenerDTO clone(FailedListenerDTO original) {
        FailedListenerDTO clone = new FailedListenerDTO();
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.types = DTOUtil.copy(original.types);
        return clone;
    }

    public static FailedPreprocessorDTO clone(FailedPreprocessorDTO original) {
        FailedPreprocessorDTO clone = new FailedPreprocessorDTO();
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        return clone;
    }

    public static FailedResourceDTO clone(FailedResourceDTO original) {
        FailedResourceDTO clone = new FailedResourceDTO();
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.prefix = DTOUtil.copy(original.prefix);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        return clone;
    }

    public static FailedServletContextDTO clone(FailedServletContextDTO original) {
        FailedServletContextDTO clone = new FailedServletContextDTO();
        clone.attributes = DTOUtil.copyGenericMap(original.attributes);
        clone.contextPath = DTOUtil.copy(original.contextPath);
        clone.errorPageDTOs = DTOUtil.copy(original.errorPageDTOs);
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.filterDTOs = DTOUtil.copy(original.filterDTOs);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.listenerDTOs = DTOUtil.copy(original.listenerDTOs);
        clone.name = DTOUtil.copy(original.name);
        clone.resourceDTOs = DTOUtil.copy(original.resourceDTOs);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletDTOs = DTOUtil.copy(original.servletDTOs);
        return clone;
    }

    public static FailedServletDTO clone(FailedServletDTO original) {
        FailedServletDTO clone = new FailedServletDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.initParams = DTOUtil.copyStringMap(clone.initParams);
        clone.multipartEnabled = DTOUtil.copy(original.multipartEnabled);
        clone.multipartFileSizeThreshold = DTOUtil.copy(original.multipartFileSizeThreshold);
        clone.multipartLocation = DTOUtil.copy(original.multipartLocation);
        clone.multipartMaxFileSize = DTOUtil.copy(original.multipartMaxFileSize);
        clone.multipartMaxRequestSize = DTOUtil.copy(original.multipartMaxRequestSize);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletInfo = DTOUtil.copy(original.servletInfo);
        return clone;
    }

    public static FilterDTO clone(FilterDTO original) {
        FilterDTO clone = new FilterDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.dispatcher = DTOUtil.copy(original.dispatcher);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.regexs = DTOUtil.copy(original.regexs);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletNames = DTOUtil.copy(original.servletNames);
        return clone;
    }

    public static ListenerDTO clone(ListenerDTO original) {
        ListenerDTO clone = new ListenerDTO();
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.types = DTOUtil.copy(original.types);
        return clone;
    }

    public static ResourceDTO clone(ResourceDTO original) {
        ResourceDTO clone = new ResourceDTO();
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.prefix = DTOUtil.copy(original.prefix);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        return clone;
    }

    public static ServletDTO clone(ServletDTO original) {
        ServletDTO clone = new ServletDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.multipartEnabled = DTOUtil.copy(original.multipartEnabled);
        clone.multipartFileSizeThreshold = DTOUtil.copy(original.multipartFileSizeThreshold);
        clone.multipartLocation = DTOUtil.copy(original.multipartLocation);
        clone.multipartMaxFileSize = DTOUtil.copy(original.multipartMaxFileSize);
        clone.multipartMaxRequestSize = DTOUtil.copy(original.multipartMaxRequestSize);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletInfo = DTOUtil.copy(original.servletInfo);
        return clone;
    }

    private static long[] copy(long[] array) {
        if (array == null) {
            return new long[0];
        }
        if (array.length == 0) {
            return array;
        }
        return Arrays.copyOf(array, array.length);
    }

    private static String[] copy(String[] array) {
        if (array == null) {
            return new String[0];
        }
        if (array.length == 0) {
            return array;
        }
        return Arrays.copyOf(array, array.length);
    }

    private static <T> T[] copy(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return array;
        }
        return Arrays.copyOf(array, array.length);
    }

    private static int copy(int value) {
        return value;
    }

    private static long copy(long value) {
        return value;
    }

    private static boolean copy(boolean value) {
        return value;
    }

    private static String copy(String value) {
        return value;
    }

    private static Map<String, String> copyStringMap(Map<String, String> initParams) {
        if (initParams == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(initParams);
    }

    public static <V> Map<String, Object> copyGenericMap(Map<String, V> value) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, V> entry : value.entrySet()) {
            result.put(entry.getKey(), DTOUtil.mapValue(entry.getValue()));
        }
        return result;
    }

    public static Object mapValue(Object v) {
        if (v == null || v instanceof Number || v instanceof Boolean || v instanceof Character || v instanceof String || v instanceof DTO) {
            return v;
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            Map<Object, Object> map = DTOUtil.newMap(m.size());
            for (Map.Entry e : m.entrySet()) {
                map.put(DTOUtil.mapValue(e.getKey()), DTOUtil.mapValue(e.getValue()));
            }
            return map;
        }
        if (v instanceof List) {
            List c = (List)v;
            List<Object> list = DTOUtil.newList(c.size());
            for (Object o : c) {
                list.add(DTOUtil.mapValue(o));
            }
            return list;
        }
        if (v instanceof Set) {
            Set c = (Set)v;
            Set<Object> set = DTOUtil.newSet(c.size());
            for (Object o : c) {
                set.add(DTOUtil.mapValue(o));
            }
            return set;
        }
        if (v.getClass().isArray()) {
            int length = Array.getLength(v);
            Class<?> componentType = DTOUtil.mapComponentType(v.getClass().getComponentType());
            Object array = Array.newInstance(componentType, length);
            int i = 0;
            while (i < length) {
                Array.set(array, i, DTOUtil.mapValue(Array.get(v, i)));
                ++i;
            }
            return array;
        }
        return String.valueOf(v);
    }

    private static void checkPattern(String pattern) {
        if (pattern == null) {
            throw new HttpWhiteboardFailureException("Pattern cannot be null", 6);
        }
        if (pattern.indexOf("*.") == 0) {
            return;
        }
        if ("".equals(pattern)) {
            return;
        }
        if ("/".equals(pattern)) {
            return;
        }
        if (!pattern.startsWith("/") || pattern.endsWith("/") && !pattern.equals("/") || pattern.contains("**")) {
            throw new HttpWhiteboardFailureException("Invalid pattern '" + pattern + "'", 6);
        }
    }

    private static Class<?> mapComponentType(Class<?> componentType) {
        if (componentType.isPrimitive() || componentType.isArray() || Object.class.equals(componentType) || Number.class.isAssignableFrom(componentType) || Boolean.class.isAssignableFrom(componentType) || Character.class.isAssignableFrom(componentType) || String.class.isAssignableFrom(componentType) || DTO.class.isAssignableFrom(componentType)) {
            return componentType;
        }
        if (Map.class.isAssignableFrom(componentType)) {
            return Map.class;
        }
        if (List.class.isAssignableFrom(componentType)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(componentType)) {
            return Set.class;
        }
        return String.class;
    }

    private static <E> List<E> newList(int size) {
        return new ArrayList(size);
    }

    private static <E> Set<E> newSet(int size) {
        return new HashSet(size);
    }

    private static <K, V> Map<K, V> newMap(int size) {
        return new HashMap(size);
    }

    private static String[] sort(String[] values) {
        if (values == null) {
            return null;
        }
        Arrays.sort(values);
        return values;
    }
}

