/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.BranchRenameDialog;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class RenameBranchOnCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Ref branchToRename;
        Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        List<Ref> branchesOfCommit = this.getBranchesOfCommit(this.getSelection(event));
        if (branchesOfCommit.isEmpty()) {
            return null;
        }
        Shell shell = this.getPart(event).getSite().getShell();
        if (branchesOfCommit.size() > 1) {
            BranchSelectionDialog<Ref> dlg = new BranchSelectionDialog<Ref>(shell, branchesOfCommit, UIText.RenameBranchOnCommitHandler_RenameBranchDialogTitle, UIText.RenameBranchOnCommitHandler_RenameBranchDialogMessage, UIText.RenameBranchOnCommitHandler_RenameBranchDialogButton, 4);
            if (dlg.open() != 0) {
                return null;
            }
            branchToRename = dlg.getSelectedNode();
        } else {
            branchToRename = branchesOfCommit.get(0);
        }
        new BranchRenameDialog(shell, repository, branchToRename).open();
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        return this.getRepository(page) != null && !this.getBranchesOfCommit(this.getSelection(page)).isEmpty();
    }
}

