/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.egit.ui.internal.variables.GitTemplateVariableResolver;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class StartEventListener
implements EventHandler {
    private final AtomicBoolean started = new AtomicBoolean();

    private void startInternalComponents() {
        if (this.started.compareAndSet(false, true)) {
            SelectionRepositoryStateCache.INSTANCE.initialize();
            this.registerCoreJobFamilyIcons();
            this.registerTemplateVariableResolvers();
        }
    }

    public void handleEvent(Event event) {
        if ("org/eclipse/e4/ui/LifeCycle/appStartupComplete".equals(event.getTopic())) {
            this.startInternalComponents();
        }
    }

    @Deactivate
    void shutDown() {
        if (this.started.get()) {
            SelectionRepositoryStateCache.INSTANCE.dispose();
        }
    }

    private void runAsync(Runnable action) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> {
                if (!display.isDisposed() && PlatformUI.isWorkbenchRunning()) {
                    action.run();
                }
            });
        }
    }

    private void registerCoreJobFamilyIcons() {
        this.runAsync(() -> {
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            if (service == null) {
                return;
            }
            service.registerIconForFamily(UIIcons.PULL, JobFamilies.PULL);
            service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.AUTO_IGNORE);
            service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.AUTO_SHARE);
            service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.INDEX_DIFF_CACHE_UPDATE);
            service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.REPOSITORY_CHANGED);
        });
    }

    private void registerTemplateVariableResolvers() {
        if (!Activator.hasJavaPlugin()) {
            return;
        }
        this.runAsync(() -> {
            try {
                ContextTypeRegistry codeTemplateContextRegistry = JavaPlugin.getDefault().getCodeTemplateContextRegistry();
                Iterator ctIter = codeTemplateContextRegistry.contextTypes();
                while (ctIter.hasNext()) {
                    TemplateContextType contextType = (TemplateContextType)ctIter.next();
                    contextType.addResolver((TemplateVariableResolver)new GitTemplateVariableResolver("git_config", UIText.GitTemplateVariableResolver_GitConfigDescription));
                }
            }
            catch (Throwable e) {
                Activator.logError("Cannot register git support for Java templates", e);
            }
        });
    }
}

