/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.internal.ui.advice;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.types.ui.advices.values.RuntimeValuesAdviceConfiguration;
import org.eclipse.papyrus.infra.emf.types.ui.advices.values.ViewToDisplay;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.creation.EditionDialog;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.swt.widgets.Display;

public class RuntimeValuesAdviceEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected Set<View> viewsToDisplay = new HashSet<View>();

    public RuntimeValuesAdviceEditHelperAdvice(RuntimeValuesAdviceConfiguration configuration) {
        for (ViewToDisplay display : configuration.getViewsToDisplay()) {
            View view = display.getView();
            if (view == null) continue;
            this.viewsToDisplay.add(view);
        }
    }

    public boolean approveRequest(IEditCommandRequest request) {
        return super.approveRequest(request);
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        return super.getBeforeCreateCommand(request);
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        return super.getAfterCreateCommand(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return super.getBeforeConfigureCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        final EObject elementToConfigure = request.getElementToConfigure();
        if (elementToConfigure == null) {
            return null;
        }
        final boolean dialogCancellable = ElementTypeUtils.dialogCancellable((IEditCommandRequest)request);
        return new AbstractTransactionalCommand(request.getEditingDomain(), "Editing " + EMFCoreUtil.getName((EObject)elementToConfigure), Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)elementToConfigure.eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int dialogResult = 0;
                Set<View> viewsToDisplay = RuntimeValuesAdviceEditHelperAdvice.this.getViewsToDisplay();
                if (!viewsToDisplay.isEmpty()) {
                    EditionDialog dialog = new EditionDialog(Display.getCurrent().getActiveShell(), dialogCancellable){};
                    dialog.setTitle("Edit " + EMFCoreUtil.getName((EObject)elementToConfigure));
                    dialog.setViews(viewsToDisplay);
                    dialog.setInput((Object)elementToConfigure);
                    dialogResult = dialog.open();
                }
                return dialogResult == 0 ? CommandResult.newOKCommandResult((Object)elementToConfigure) : CommandResult.newCancelledCommandResult();
            }
        };
    }

    public Set<View> getViewsToDisplay() {
        return this.viewsToDisplay;
    }
}

