/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.AbstractFileEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IProjectEditor;

public abstract class AbstractProjectEditor
extends AbstractFileEditor
implements IProjectEditor {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private final IProjectDescription description;

    public AbstractProjectEditor(IProject project) throws CoreException {
        super(project);
        this.description = this.getProject().getDescription();
    }

    AbstractProjectEditor(AbstractProjectEditor master) {
        super(master.getProject());
        this.description = master.description;
    }

    @Override
    public boolean exists() {
        return super.exists() && this.getMissingNature().size() == 0 && this.getMissingBuildCommand().size() == 0;
    }

    @Override
    public void create() {
        this.createFiles(this.getMissingFiles());
        this.addNatures(this.getMissingNature());
        this.addBuildCommands(this.getMissingBuildCommand());
        this.init();
    }

    @Override
    public boolean hasNature(String nature) {
        LinkedList<String> natures = new LinkedList<String>(Arrays.asList(this.description.getNatureIds()));
        return natures.contains(nature);
    }

    @Override
    public Set<String> getMissingNature() {
        return new HashSet<String>();
    }

    @Override
    public void addNatures(Set<String> natures) {
        LinkedList<String> existingNatures = new LinkedList<String>(Arrays.asList(this.description.getNatureIds()));
        boolean added = false;
        for (String nature : natures) {
            if (existingNatures.contains(nature)) continue;
            existingNatures.add(nature);
            added = true;
        }
        if (added) {
            this.touch();
            this.description.setNatureIds(existingNatures.toArray(new String[existingNatures.size()]));
        }
    }

    @Override
    public boolean hasBuildCommand(String command) {
        ICommand[] buildSpec = this.description.getBuildSpec();
        int i = 0;
        while (i < buildSpec.length) {
            if (buildSpec[i].getBuilderName().equals(command)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void addBuildCommands(Set<String> commands) {
        ICommand[] buildSpec = this.description.getBuildSpec();
        ArrayList<ICommand> buildSpecList = new ArrayList<ICommand>();
        buildSpecList.addAll(Arrays.asList(buildSpec));
        boolean added = false;
        for (String name : commands) {
            if (this.hasBuildCommand(name)) continue;
            ICommand cmd = this.description.newCommand();
            cmd.setBuilderName(name);
            buildSpecList.add(cmd);
            added = true;
        }
        if (added) {
            this.touch();
            this.description.setBuildSpec(buildSpecList.toArray(new ICommand[buildSpecList.size()]));
        }
    }

    @Override
    protected void doSave() {
        if (this.description != null) {
            try {
                this.getProject().setDescription(this.description, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        return new HashSet<String>();
    }
}

