/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionTreeContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObservableListTreeContentProvider<E>
implements ITreeContentProvider {
    private final ObservableCollectionTreeContentProvider<E> impl;

    public ObservableListTreeContentProvider(IObservableFactory<? super E, ? extends IObservableList<E>> listFactory, TreeStructureAdvisor<? super E> structureAdvisor) {
        this.impl = new Impl<E>(listFactory, structureAdvisor);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.impl.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        return this.impl.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.impl.getParent(element);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet<E> getKnownElements() {
        return this.impl.getKnownElements();
    }

    public IObservableSet<E> getRealizedElements() {
        return this.impl.getRealizedElements();
    }

    private static class Impl<E>
    extends ObservableCollectionTreeContentProvider<E> {
        private Viewer viewer;

        public Impl(IObservableFactory<? super E, ? extends IObservableList<E>> listFactory, TreeStructureAdvisor<? super E> structureAdvisor) {
            super(listFactory, structureAdvisor);
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }

        @Override
        protected IObservablesListener createCollectionChangeListener(E parentElement) {
            return new ListChangeListener(parentElement);
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection<E> collection, IObservablesListener listener) {
            IObservableList list = (IObservableList)collection;
            IListChangeListener listListener = (IListChangeListener)listener;
            list.addListChangeListener(listListener);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection<E> collection, IObservablesListener listener) {
            IObservableList list = (IObservableList)collection;
            IListChangeListener listListener = (IListChangeListener)listener;
            list.removeListChangeListener(listListener);
        }

        private class ListChangeListener
        implements IListChangeListener<E> {
            final E parentElement;

            public ListChangeListener(E parentElement) {
                this.parentElement = parentElement;
            }

            public void handleListChange(ListChangeEvent<? extends E> event) {
                if (Impl.this.isViewerDisposed()) {
                    return;
                }
                final Set localKnownElementAdditions = ViewerElementSet.withComparer(Impl.this.comparer);
                final Set localKnownElementRemovals = ViewerElementSet.withComparer(Impl.this.comparer);
                final boolean[] suspendRedraw = new boolean[1];
                event.diff.accept(new ListDiffVisitor<E>(){

                    public void handleAdd(int index, E element) {
                        localKnownElementAdditions.add(element);
                    }

                    public void handleRemove(int index, E element) {
                        localKnownElementRemovals.add(element);
                    }

                    public void handleMove(int oldIndex, int newIndex, E element) {
                        suspendRedraw[0] = true;
                    }

                    public void handleReplace(int index, E oldElement, E newElement) {
                        suspendRedraw[0] = true;
                        super.handleReplace(index, oldElement, newElement);
                    }
                });
                localKnownElementRemovals.removeAll((Collection<?>)event.getObservableList());
                Set knownElementAdditions = ViewerElementSet.withComparer(Impl.this.comparer);
                knownElementAdditions.addAll(localKnownElementAdditions);
                knownElementAdditions.removeAll((Collection<?>)Impl.this.knownElements);
                Set knownElementRemovals = Impl.this.findPendingRemovals(this.parentElement, localKnownElementRemovals);
                knownElementRemovals.retainAll((Collection<?>)Impl.this.knownElements);
                Impl.this.knownElements.addAll(knownElementAdditions);
                if (Impl.this.realizedElements != null) {
                    Impl.this.realizedElements.removeAll((Collection)knownElementRemovals);
                }
                for (Object element : localKnownElementAdditions) {
                    Impl.this.getOrCreateNode(element).addParent(this.parentElement);
                }
                if (suspendRedraw[0]) {
                    Impl.this.viewer.getControl().setRedraw(false);
                }
                try {
                    event.diff.accept((ListDiffVisitor)new ListDiffVisitor<Object>(){

                        public void handleAdd(int index, Object child) {
                            Impl.this.viewerUpdater.insert(ListChangeListener.this.parentElement, child, index);
                        }

                        public void handleRemove(int index, Object child) {
                            Impl.this.viewerUpdater.remove(ListChangeListener.this.parentElement, child, index);
                        }

                        public void handleReplace(int index, Object oldChild, Object newChild) {
                            Impl.this.viewerUpdater.replace(ListChangeListener.this.parentElement, oldChild, newChild, index);
                        }

                        public void handleMove(int oldIndex, int newIndex, Object child) {
                            Impl.this.viewerUpdater.move(ListChangeListener.this.parentElement, child, oldIndex, newIndex);
                        }
                    });
                }
                finally {
                    if (suspendRedraw[0]) {
                        Impl.this.viewer.getControl().setRedraw(true);
                    }
                }
                for (Object element : localKnownElementRemovals) {
                    ObservableCollectionTreeContentProvider.TreeNode node = Impl.this.getExistingNode(element);
                    if (node == null) continue;
                    node.removeParent(this.parentElement);
                }
                if (Impl.this.realizedElements != null) {
                    Impl.this.realizedElements.addAll(knownElementAdditions);
                }
                Impl.this.knownElements.removeAll((Collection)knownElementRemovals);
            }
        }
    }
}

