/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionPreferences;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;

public class SashLayoutCommandFactory {
    private final IMultiDiagramEditor editor;

    public SashLayoutCommandFactory(IMultiDiagramEditor editor) {
        this.editor = editor;
    }

    public Command createTogglePrivateLayoutCommand() {
        Object result = UnexecutableCommand.INSTANCE;
        final ModelSet modelSet = (ModelSet)((EditingDomain)this.editor.getAdapter(EditingDomain.class)).getResourceSet();
        final SashModel sashModel = SashModelUtils.getSashModel((ModelSet)modelSet);
        if (sashModel != null) {
            result = new AbstractToggleCommand("Toggle Private Editor Layout"){
                private Command toggleRestoreActivePage;
                {
                    SashWindowsMngr sash;
                    super($anonymous0);
                    if (!sashModel2.isLegacyMode() && (sash = DiUtils.lookupSashWindowsMngr((Resource)sashModel2.getResource())) != null && sash.getSashModel() != null && sash.getSashModel().isRestoreActivePage()) {
                        this.toggleRestoreActivePage = SashLayoutCommandFactory.this.createToggleRestoreActivePageCommand();
                    }
                }

                public void execute() {
                    if (this.toggleRestoreActivePage != null && this.toggleRestoreActivePage.canExecute()) {
                        this.toggleRestoreActivePage.execute();
                    }
                    SashWindowsMngr toMove = DiUtils.lookupSashWindowsMngr((Resource)sashModel.getResource());
                    if (!sashModel.isLegacyMode()) {
                        Resource sashResource = toMove.eResource();
                        URI sharedURI = sashModel.getSharedResourceURI();
                        Resource diResource = modelSet.getResource(sharedURI, false);
                        if (diResource != null && diResource.isLoaded()) {
                            SashLayoutCommandFactory.this.moveContents(sashResource, diResource);
                            if (sashResource.getContents().isEmpty()) {
                                modelSet.getResourcesToDeleteOnSave().add(sashResource.getURI());
                            }
                        }
                    } else {
                        URI privateURI = sashModel.getPrivateResourceURI();
                        Resource sashResource = modelSet.getURIConverter().exists(privateURI, null) ? modelSet.getResource(privateURI, true) : modelSet.createResource(privateURI);
                        modelSet.getResourcesToDeleteOnSave().remove(privateURI);
                        Resource diResource = toMove.eResource();
                        SashLayoutCommandFactory.this.moveContents(diResource, sashResource);
                    }
                    sashModel.loadModel(modelSet.getURIWithoutExtension());
                }
            };
        }
        return result;
    }

    void moveContents(Resource fromResource, Resource toResource) {
        for (EObject root : new ArrayList(fromResource.getContents())) {
            if (!(root instanceof SashWindowsMngr) && !(root instanceof ArchitectureDescriptionPreferences)) continue;
            EObject toReplace = (EObject)EcoreUtil.getObjectByType((Collection)toResource.getContents(), (EClassifier)root.eClass());
            if (toReplace != null) {
                EcoreUtil.replace((EObject)toReplace, (EObject)root);
                continue;
            }
            if (root instanceof SashWindowsMngr) {
                toResource.getContents().add(0, (Object)root);
                continue;
            }
            toResource.getContents().add((Object)root);
        }
    }

    public Command createToggleRestoreActivePageCommand() {
        Object result = UnexecutableCommand.INSTANCE;
        ModelSet modelSet = (ModelSet)((EditingDomain)this.editor.getAdapter(EditingDomain.class)).getResourceSet();
        SashWindowsMngr sashWindows = SashModelUtils.getSashWindowsMngr((ModelSet)modelSet);
        final ISashWindowsContainer container = (ISashWindowsContainer)this.editor.getAdapter(ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sashwindows.di.SashModel sashModel = sashWindows.getSashModel();
        if (sashModel != null) {
            result = new AbstractToggleCommand("Toggle Restore Active Page"){

                public void execute() {
                    boolean oldValue = sashModel.isRestoreActivePage();
                    if (oldValue) {
                        container.getIFolderList().stream().map(f -> f.getRawModel()).filter(TabFolder.class::isInstance).map(TabFolder.class::cast).filter(f -> f.getCurrentSelection() != null).forEach(f -> f.setCurrentSelection(null));
                    } else {
                        container.getVisiblePages().stream().map(p -> p.getRawModel()).filter(PageRef.class::isInstance).map(PageRef.class::cast).filter(p -> p.getParent().getCurrentSelection() != p).forEach(p -> p.getParent().setCurrentSelection(p));
                    }
                    sashModel.setRestoreActivePage(!oldValue);
                }
            };
        }
        return result;
    }

    private static abstract class AbstractToggleCommand
    extends AbstractCommand {
        AbstractToggleCommand(String label) {
            super(label);
        }

        protected boolean prepare() {
            return true;
        }

        public void undo() {
            this.execute();
        }

        public void redo() {
            this.execute();
        }
    }
}

