/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.converter;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.tools.util.BooleanHelper;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.infra.ui.converter.ConvertedValueContainer;
import org.eclipse.papyrus.infra.ui.converter.MultiConvertedValueContainer;
import org.eclipse.papyrus.infra.ui.converter.StringValueConverterStatus;

public class EMFStringValueConverter
extends AbstractStringValueConverter {
    private EObject resolutionContext;
    protected final String multiValueSeparator;

    public EMFStringValueConverter(EObject resolutionContext, String multiValueSeparator) {
        this.resolutionContext = resolutionContext;
        this.multiValueSeparator = multiValueSeparator;
    }

    public EObject getResolutionContext() {
        return this.resolutionContext;
    }

    public void dispose() {
        this.resolutionContext = null;
    }

    @Override
    protected ConvertedValueContainer<?> doDeduceValueFromString(Object feature, String valueAsString) {
        EClassifier featureType = this.getFeatureType(feature);
        if (feature instanceof EStructuralFeature) {
            return this.deduceValueFromString(feature, featureType, valueAsString);
        }
        return null;
    }

    protected ConvertedValueContainer<?> deduceValueFromString(Object feature, EClassifier featureType, String valueAsString) {
        boolean isMany;
        ConvertedValueContainer<?> realValue = null;
        int upperbound = this.getFeatureUpperBound(feature);
        boolean bl = isMany = upperbound > 1 || upperbound == -1;
        if (featureType instanceof EDataType) {
            String typeName;
            if (featureType instanceof EEnum) {
                realValue = this.deduceEEnumLiteralValue((EEnum)featureType, isMany, valueAsString);
            }
            if ("String".equals(typeName = featureType.getName()) || "EString".equals(typeName)) {
                realValue = this.deduceStringValue(isMany, valueAsString);
            } else if ("EBoolean".equals(typeName) || "Boolean".equals(typeName)) {
                realValue = this.deduceBooleanValue(isMany, valueAsString);
            } else if ("EInt".equals(typeName) || "Integer".equals(typeName)) {
                realValue = this.deduceIntValue(isMany, valueAsString);
            } else if ("EDouble".equals(typeName)) {
                realValue = this.deduceDoubleValue(isMany, valueAsString);
            }
        } else if (featureType instanceof EClass) {
            realValue = this.deduceEObjectValue(this.getResolutionContext(), feature, (EClass)featureType, isMany, valueAsString);
        }
        return realValue;
    }

    protected int getFeatureUpperBound(Object feature) {
        return ((EStructuralFeature)feature).getUpperBound();
    }

    protected ConvertedValueContainer<?> deduceEObjectValue(EObject resolutionContext, Object feature, EClass featureType, boolean isMany, String valueAsString) {
        if (valueAsString == null || valueAsString.equals("")) {
            return new ConvertedValueContainer<Object>(null, Status.OK_STATUS);
        }
        StringValueConverterStatus status = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)NO_X_REPRESENTED_BY_Y_HAVE_BEEN_FOUND, (Object)featureType.getName(), (Object)valueAsString), Collections.singleton(valueAsString));
        return new ConvertedValueContainer<Object>(null, (IStatus)status);
    }

    protected EClassifier getFeatureType(Object feature) {
        if (feature instanceof EStructuralFeature) {
            return ((EStructuralFeature)feature).getEType();
        }
        EClassifier featureType = null;
        return featureType;
    }

    protected ConvertedValueContainer<?> deduceEEnumLiteralValue(EEnum eenum, boolean isMany, String valueAsString) {
        ConvertedValueContainer<Enumerator> returnedValue = null;
        Object iStatus = Status.OK_STATUS;
        ArrayList<String> unresolvedValues = new ArrayList<String>();
        if (isMany) {
            ArrayList<EEnumLiteral> values = new ArrayList<EEnumLiteral>();
            String[] stringArray = valueAsString.split(this.multiValueSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                EEnumLiteral literal = eenum.getEEnumLiteral(str);
                if (literal != null) {
                    values.add(literal);
                } else {
                    unresolvedValues.add(str);
                }
                ++n2;
            }
            if (!unresolvedValues.isEmpty()) {
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)SOME_STRING_ARE_NOT_VALID_TO_CREATE_X, (Object)"EENumLiteral"), unresolvedValues);
            }
            returnedValue = new MultiConvertedValueContainer(values, (IStatus)iStatus);
        } else {
            EEnumLiteral literal = eenum.getEEnumLiteral(valueAsString);
            if (literal != null) {
                returnedValue = new ConvertedValueContainer<Enumerator>(literal.getInstance(), (IStatus)iStatus);
            } else {
                unresolvedValues.add(valueAsString);
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)THE_STRING_X_IS_NOT_VALID_TO_CREATE_Y, (Object)valueAsString, (Object)"EENumLiteral"), unresolvedValues);
                returnedValue = new ConvertedValueContainer<Object>(null, (IStatus)iStatus);
            }
        }
        return returnedValue;
    }

    protected ConvertedValueContainer<?> deduceBooleanValue(boolean isMany, String valueAsString) {
        ConvertedValueContainer<Boolean> returnedValue = null;
        Object iStatus = Status.OK_STATUS;
        ArrayList<String> unresolvedValues = new ArrayList<String>();
        if (isMany) {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            String[] stringArray = valueAsString.split(this.multiValueSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (BooleanHelper.isBoolean((String)str)) {
                    values.add(Boolean.valueOf(valueAsString));
                } else {
                    unresolvedValues.add(str);
                }
                ++n2;
            }
            if (!unresolvedValues.isEmpty()) {
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)SOME_STRING_ARE_NOT_VALID_TO_CREATE_X, (Object)"Boolean"), unresolvedValues);
            }
            returnedValue = new MultiConvertedValueContainer(values, (IStatus)iStatus);
        } else if (BooleanHelper.isBoolean((String)valueAsString)) {
            returnedValue = new ConvertedValueContainer<Boolean>(Boolean.valueOf(valueAsString), (IStatus)iStatus);
        } else {
            unresolvedValues.add(valueAsString);
            iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)THE_STRING_X_IS_NOT_VALID_TO_CREATE_Y, (Object)valueAsString, (Object)"Boolean"), unresolvedValues);
            returnedValue = new ConvertedValueContainer<Object>(null, (IStatus)iStatus);
        }
        return returnedValue;
    }

    protected ConvertedValueContainer<?> deduceDoubleValue(boolean isMany, String valueAsString) {
        ConvertedValueContainer<Double> returnedValue = null;
        Object iStatus = Status.OK_STATUS;
        ArrayList<String> unresolvedValues = new ArrayList<String>();
        if (isMany) {
            ArrayList<Double> values = new ArrayList<Double>();
            String[] stringArray = valueAsString.split(this.multiValueSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                Double value = Double.valueOf(str);
                if (value != null) {
                    values.add(value);
                } else {
                    unresolvedValues.add(str);
                }
                ++n2;
            }
            if (!unresolvedValues.isEmpty()) {
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)SOME_STRING_ARE_NOT_VALID_TO_CREATE_X, (Object)"Double"), unresolvedValues);
            }
            returnedValue = new MultiConvertedValueContainer(values, (IStatus)iStatus);
        } else {
            try {
                returnedValue = new ConvertedValueContainer<Double>(Double.valueOf(valueAsString), (IStatus)iStatus);
            }
            catch (NumberFormatException e) {
                unresolvedValues.add(valueAsString);
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)THE_STRING_X_IS_NOT_VALID_TO_CREATE_Y, (Object)valueAsString, (Object)"Double"), unresolvedValues);
                returnedValue = new ConvertedValueContainer<Object>(null, (IStatus)iStatus);
            }
        }
        return returnedValue;
    }

    protected ConvertedValueContainer<?> deduceIntValue(boolean isMany, String valueAsString) {
        ConvertedValueContainer<Integer> returnedValue = null;
        Object iStatus = Status.OK_STATUS;
        ArrayList<String> unresolvedValues = new ArrayList<String>();
        if (isMany) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            String[] stringArray = valueAsString.split(this.multiValueSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                try {
                    values.add(Integer.valueOf(str));
                }
                catch (NumberFormatException e) {
                    unresolvedValues.add(str);
                }
                ++n2;
            }
            if (!unresolvedValues.isEmpty()) {
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)SOME_STRING_ARE_NOT_VALID_TO_CREATE_X, (Object)"Integer"), unresolvedValues);
            }
            returnedValue = new MultiConvertedValueContainer(values, (IStatus)iStatus);
        } else {
            try {
                returnedValue = new ConvertedValueContainer<Integer>(Integer.valueOf(valueAsString), (IStatus)iStatus);
            }
            catch (NumberFormatException e) {
                unresolvedValues.add(valueAsString);
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.ui", NLS.bind((String)THE_STRING_X_IS_NOT_VALID_TO_CREATE_Y, (Object)valueAsString, (Object)"Integer"), unresolvedValues);
                returnedValue = new ConvertedValueContainer<Object>(null, (IStatus)iStatus);
            }
        }
        return returnedValue;
    }

    protected ConvertedValueContainer<?> deduceStringValue(boolean isMany, String valueAsString) {
        ConvertedValueContainer<String> returnedValue = null;
        IStatus iStatus = Status.OK_STATUS;
        if (isMany) {
            ArrayList<String> values = new ArrayList<String>();
            String[] stringArray = valueAsString.split(this.multiValueSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                values.add(str);
                ++n2;
            }
            returnedValue = new MultiConvertedValueContainer(values, iStatus);
        } else {
            returnedValue = new ConvertedValueContainer<String>(valueAsString, iStatus);
        }
        return returnedValue;
    }
}

