/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.xtend.parser.ParseFacade;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFacade {
    private ExecutionContext execContext;

    public ExecutionContext getExecContext() {
        return this.execContext;
    }

    public ExpressionFacade(ExecutionContext execCtx) {
        this.execContext = execCtx;
    }

    public Type analyze(String expression, Set<AnalysationIssue> issues) {
        Expression expr = this.parse(expression);
        return expr.analyze(this.execContext, issues);
    }

    public Object evaluate(String expression) {
        return this.evaluate(expression, Collections.emptyMap());
    }

    public Object evaluate(String expression, Map<String, ?> context) {
        Expression expr = this.parse(expression);
        ExecutionContext ctx = this.execContext;
        for (String key : context.keySet()) {
            Variable v = new Variable(key, context.get(key));
            ctx = ctx.cloneWithVariable(v);
        }
        return expr.evaluate(ctx);
    }

    public Expression parse(String expression) {
        return ParseFacade.expression(expression);
    }

    public ExpressionFacade cloneWithVariable(Variable variable) {
        ExecutionContext ctx = this.execContext.cloneWithVariable(variable);
        return new ExpressionFacade(ctx);
    }
}

