/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.GMFElementProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ICSSElementProviderFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.CSSDOMSemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.IPapyrusElementProvider;
import org.w3c.dom.Element;

public class ElementProviderWrapper
implements IPapyrusElementProvider {
    public static final String EXTENSION_POINT = "org.eclipse.papyrus.infra.gmfdiag.css.domElementAdapter";
    private IElementProvider delegate;

    public ElementProviderWrapper(CSSDiagram diagram) {
        this.delegate = this.getElementProviderFor(diagram);
    }

    public Element getElement(Object element, CSSEngine engine) {
        return this.delegate.getElement(element, engine);
    }

    private List<ICSSElementProviderFactory> getCSSElementProviders() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        TreeMap<Integer, List<ICSSElementProviderFactory>> sortedFactories = new TreeMap<Integer, List<ICSSElementProviderFactory>>();
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                int order = Integer.parseInt(e.getAttribute("order"));
                ICSSElementProviderFactory factory = (ICSSElementProviderFactory)e.createExecutableExtension("factory");
                this.getFactories(sortedFactories, order).add(factory);
            }
            catch (Exception ex) {
                Activator.log.error(String.format("Plugin %s contributed an invalid CSS DOM Element Provider Factory", e.getContributor()), (Throwable)ex);
            }
            ++n2;
        }
        LinkedList<ICSSElementProviderFactory> factories = new LinkedList<ICSSElementProviderFactory>();
        for (List factoriesEntry : sortedFactories.values()) {
            factories.addAll(factoriesEntry);
        }
        return factories;
    }

    private List<ICSSElementProviderFactory> getFactories(Map<Integer, List<ICSSElementProviderFactory>> sortedFactories, int order) {
        if (!sortedFactories.containsKey(order)) {
            sortedFactories.put(order, new LinkedList());
        }
        return sortedFactories.get(order);
    }

    private IPapyrusElementProvider getElementProviderFor(CSSDiagram diagram) {
        for (ICSSElementProviderFactory providerFactory : this.getCSSElementProviders()) {
            if (!providerFactory.isProviderFor(diagram)) continue;
            return providerFactory.createProvider(diagram);
        }
        return new GMFElementProvider();
    }

    @Override
    public View getPrimaryView(EObject notationElement) {
        View canonicalNotationElement = null;
        canonicalNotationElement = this.delegate instanceof IPapyrusElementProvider ? ((IPapyrusElementProvider)this.delegate).getPrimaryView(notationElement) : CSSDOMSemanticElementHelper.getInstance().findPrimaryView(notationElement);
        return canonicalNotationElement;
    }
}

