/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IBranchDeletionSupport;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.net4j.db.Batch;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class DurableLockingManager
extends Lifecycle
implements IBranchDeletionSupport {
    private static final String LOCK_AREAS = "CDO_LOCK_AREAS";
    private static final String LOCK_AREAS_ID = "ID";
    private static final String LOCK_AREAS_USER_ID = "USER_ID";
    private static final String LOCK_AREAS_VIEW_BRANCH = "VIEW_BRANCH";
    private static final String LOCK_AREAS_VIEW_TIME = "VIEW_TIME";
    private static final String LOCK_AREAS_READ_ONLY = "READ_ONLY";
    private static final String LOCKS = "CDO_LOCKS";
    private static final String LOCKS_AREA_ID = "AREA_ID";
    private static final String LOCKS_OBJECT_ID = "OBJECT_ID";
    private static final String LOCKS_LOCK_GRADE = "LOCK_GRADE";
    private DBStore store;
    private InternalCDOBranchManager branchManager;
    private IIDHandler idHandler;
    private IDBTable lockAreasTable;
    private IDBTable locksTable;
    private String sqlInsertLockArea;
    private String sqlSelectLockArea;
    private String sqlSelectAllLockAreas;
    private String sqlSelectLockAreas;
    private String sqlDeleteLockArea;
    private String sqlDeleteLockAreas;
    private String sqlSelectLocks;
    private String sqlSelectLock;
    private String sqlInsertLock;
    private String sqlUpdateLock;
    private String sqlDeleteLock;
    private String sqlDeleteLocks;

    public DurableLockingManager(DBStore store) {
        this.store = store;
    }

    public synchronized IDurableLockingManager.LockArea createLockArea(DBStoreAccessor accessor, String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        if (durableLockingID == null) {
            durableLockingID = this.getNextDurableLockingID(accessor);
        } else {
            try {
                this.getLockArea(accessor, durableLockingID);
                throw new IDurableLockingManager.LockAreaAlreadyExistsException(durableLockingID);
            }
            catch (IDurableLockingManager.LockAreaNotFoundException lockAreaNotFoundException) {
                // empty catch block
            }
        }
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(this.sqlInsertLockArea, IDBPreparedStatement.ReuseProbability.LOW);
        try {
            try {
                stmt.setString(1, durableLockingID);
                stmt.setString(2, userID);
                stmt.setInt(3, branchPoint.getBranch().getID());
                stmt.setLong(4, branchPoint.getTimeStamp());
                stmt.setBoolean(5, readOnly);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        if (!locks.isEmpty()) {
            this.insertLocks(accessor, durableLockingID, locks);
        }
        DurableLockingManager.commit(accessor);
        return CDOLockUtil.createLockArea((String)durableLockingID, (String)userID, (CDOBranchPoint)branchPoint, (boolean)readOnly, locks);
    }

    private void insertLocks(DBStoreAccessor accessor, String durableLockingID, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(this.sqlInsertLock, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                stmt.setString(1, durableLockingID);
                for (Map.Entry<CDOID, IDurableLockingManager.LockGrade> entry : locks.entrySet()) {
                    CDOID id = entry.getKey();
                    int grade = entry.getValue().getValue();
                    this.idHandler.setCDOID((PreparedStatement)stmt, 2, id);
                    stmt.setInt(3, grade);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public IDurableLockingManager.LockArea getLockArea(DBStoreAccessor accessor, String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        IDurableLockingManager.LockArea lockArea;
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(this.sqlSelectLockArea, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            stmt.setString(1, durableLockingID);
            resultSet = stmt.executeQuery();
            if (!resultSet.next()) {
                throw new IDurableLockingManager.LockAreaNotFoundException(durableLockingID);
            }
            String userID = resultSet.getString(1);
            int branchID = resultSet.getInt(2);
            long timeStamp = resultSet.getLong(3);
            boolean readOnly = resultSet.getBoolean(4);
            lockArea = this.makeLockArea(accessor, durableLockingID, userID, branchID, timeStamp, readOnly);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return lockArea;
    }

    public void getLockAreas(DBStoreAccessor accessor, String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = null;
        IDBResultSet resultSet = null;
        try {
            try {
                if (userIDPrefix.length() == 0) {
                    stmt = connection.prepareStatement(this.sqlSelectAllLockAreas, IDBPreparedStatement.ReuseProbability.MEDIUM);
                } else {
                    stmt = connection.prepareStatement(this.sqlSelectLockAreas, IDBPreparedStatement.ReuseProbability.MEDIUM);
                    stmt.setString(1, String.valueOf(userIDPrefix) + "%");
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    boolean readOnly;
                    long timeStamp;
                    int branchID;
                    String userID;
                    String durableLockingID = resultSet.getString(1);
                    IDurableLockingManager.LockArea area = this.makeLockArea(accessor, durableLockingID, userID = resultSet.getString(2), branchID = resultSet.getInt(3), timeStamp = resultSet.getLong(4), readOnly = resultSet.getBoolean(5));
                    if (handler.handleLockArea(area)) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    public void deleteLockArea(DBStoreAccessor accessor, String durableLockingID) {
        this.unlockWithoutCommit(accessor, durableLockingID);
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(this.sqlDeleteLockArea, IDBPreparedStatement.ReuseProbability.LOW);
        try {
            try {
                stmt.setString(1, durableLockingID);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        DurableLockingManager.commit(accessor);
    }

    public void updateLockArea(DBStoreAccessor accessor, IDurableLockingManager.LockArea area) {
        String areaID = area.getDurableLockingID();
        this.unlockWithoutCommit(accessor, areaID);
        this.insertLocks(accessor, areaID, area.getLocks());
        DurableLockingManager.commit(accessor);
    }

    public void lock(DBStoreAccessor accessor, String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        this.changeLocks(accessor, durableLockingID, type, objectsToLock, true);
    }

    public void unlock(DBStoreAccessor accessor, String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        if (objectsToUnlock == null) {
            this.unlockWithoutCommit(accessor, durableLockingID);
            DurableLockingManager.commit(accessor);
        } else {
            this.changeLocks(accessor, durableLockingID, type, objectsToUnlock, false);
        }
    }

    private void unlockWithoutCommit(DBStoreAccessor accessor, String durableLockingID) {
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(this.sqlDeleteLocks, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                stmt.setString(1, durableLockingID);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.branchManager = this.store.getRepository().getBranchManager();
        this.idHandler = this.store.getIDHandler();
        IDBDatabase database = this.store.getDatabase();
        this.lockAreasTable = database.getSchema().getTable(LOCK_AREAS);
        if (this.lockAreasTable == null) {
            database.updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    DurableLockingManager.this.lockAreasTable = schema.addTable(DurableLockingManager.LOCK_AREAS);
                    DurableLockingManager.this.lockAreasTable.addField(DurableLockingManager.LOCK_AREAS_ID, DBType.VARCHAR, true);
                    DurableLockingManager.this.lockAreasTable.addField(DurableLockingManager.LOCK_AREAS_USER_ID, DBType.VARCHAR);
                    DurableLockingManager.this.lockAreasTable.addField(DurableLockingManager.LOCK_AREAS_VIEW_BRANCH, DBType.INTEGER);
                    DurableLockingManager.this.lockAreasTable.addField(DurableLockingManager.LOCK_AREAS_VIEW_TIME, DBType.BIGINT);
                    DurableLockingManager.this.lockAreasTable.addField(DurableLockingManager.LOCK_AREAS_READ_ONLY, DBType.BOOLEAN);
                    DurableLockingManager.this.lockAreasTable.addIndex(IDBIndex.Type.PRIMARY_KEY, new String[]{DurableLockingManager.LOCK_AREAS_ID});
                    DurableLockingManager.this.lockAreasTable.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{DurableLockingManager.LOCK_AREAS_USER_ID});
                }
            });
        }
        this.sqlInsertLockArea = "INSERT INTO CDO_LOCK_AREAS(ID,USER_ID,VIEW_BRANCH,VIEW_TIME,READ_ONLY) VALUES (?, ?, ?, ?, ?)";
        this.sqlSelectLockArea = "SELECT USER_ID,VIEW_BRANCH,VIEW_TIME,READ_ONLY FROM CDO_LOCK_AREAS WHERE ID=?";
        this.sqlSelectAllLockAreas = "SELECT ID,USER_ID,VIEW_BRANCH,VIEW_TIME,READ_ONLY FROM CDO_LOCK_AREAS";
        this.sqlSelectLockAreas = String.valueOf(this.sqlSelectAllLockAreas) + " WHERE " + LOCK_AREAS_USER_ID + " LIKE ?";
        this.sqlDeleteLockArea = "DELETE FROM CDO_LOCK_AREAS WHERE ID=?";
        this.sqlDeleteLockAreas = "DELETE FROM CDO_LOCK_AREAS WHERE EXISTS (SELECT * FROM CDO_LOCKS WHERE CDO_LOCKS.AREA_ID=CDO_LOCK_AREAS.ID)";
        this.locksTable = database.getSchema().getTable(LOCKS);
        if (this.locksTable == null) {
            database.updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    DurableLockingManager.this.locksTable = schema.addTable(DurableLockingManager.LOCKS);
                    DurableLockingManager.this.locksTable.addField(DurableLockingManager.LOCKS_AREA_ID, DBType.VARCHAR, true);
                    DurableLockingManager.this.locksTable.addField(DurableLockingManager.LOCKS_OBJECT_ID, DurableLockingManager.this.idHandler.getDBType(), DurableLockingManager.this.store.getIDColumnLength(), true);
                    DurableLockingManager.this.locksTable.addField(DurableLockingManager.LOCKS_LOCK_GRADE, DBType.INTEGER);
                    DurableLockingManager.this.locksTable.addIndex(IDBIndex.Type.PRIMARY_KEY, new String[]{DurableLockingManager.LOCKS_AREA_ID, DurableLockingManager.LOCKS_OBJECT_ID});
                    DurableLockingManager.this.locksTable.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{DurableLockingManager.LOCKS_AREA_ID});
                }
            });
        }
        this.sqlSelectLocks = "SELECT OBJECT_ID,LOCK_GRADE FROM CDO_LOCKS WHERE AREA_ID=?";
        this.sqlSelectLock = "SELECT LOCK_GRADE FROM CDO_LOCKS WHERE AREA_ID=? AND OBJECT_ID=?";
        this.sqlInsertLock = "INSERT INTO CDO_LOCKS(AREA_ID,OBJECT_ID,LOCK_GRADE) VALUES (?, ?, ?)";
        this.sqlUpdateLock = "UPDATE CDO_LOCKS SET LOCK_GRADE=?  WHERE AREA_ID=? AND OBJECT_ID=?";
        this.sqlDeleteLock = "DELETE FROM CDO_LOCKS WHERE AREA_ID=? AND OBJECT_ID=?";
        this.sqlDeleteLocks = "DELETE FROM CDO_LOCKS WHERE AREA_ID=?";
    }

    private String getNextDurableLockingID(DBStoreAccessor accessor) {
        while (true) {
            String durableLockingID = CDOLockUtil.createDurableLockingID();
            try {
                this.getLockArea(accessor, durableLockingID);
            }
            catch (IDurableLockingManager.LockAreaNotFoundException ex) {
                return durableLockingID;
            }
        }
    }

    private IDurableLockingManager.LockArea makeLockArea(DBStoreAccessor accessor, String durableLockingID, String userID, int branchID, long timeStamp, boolean readOnly) {
        CDOBranchPoint branchPoint = this.branchManager.getBranch(branchID).getPoint(timeStamp);
        Map<CDOID, IDurableLockingManager.LockGrade> lockMap = this.getLockMap(accessor, durableLockingID);
        return CDOLockUtil.createLockArea((String)durableLockingID, (String)userID, (CDOBranchPoint)branchPoint, (boolean)readOnly, lockMap);
    }

    private Map<CDOID, IDurableLockingManager.LockGrade> getLockMap(DBStoreAccessor accessor, String durableLockingID) {
        Map map;
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(this.sqlSelectLocks, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            stmt.setString(1, durableLockingID);
            resultSet = stmt.executeQuery();
            Map lockMap = CDOIDUtil.createMap();
            while (resultSet.next()) {
                CDOID id = this.idHandler.getCDOID((ResultSet)resultSet, 1);
                int grade = resultSet.getInt(2);
                lockMap.put(id, IDurableLockingManager.LockGrade.get((int)grade));
            }
            map = lockMap;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return map;
    }

    private void changeLocks(DBStoreAccessor accessor, String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> keys, boolean on) {
        if (keys.isEmpty()) {
            return;
        }
        String sqlInsertOrDelete = on ? this.sqlInsertLock : this.sqlDeleteLock;
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmtSelect = connection.prepareStatement(this.sqlSelectLock, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBPreparedStatement stmtInsertOrDelete = connection.prepareStatement(sqlInsertOrDelete, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBPreparedStatement stmtUpdate = connection.prepareStatement(this.sqlUpdateLock, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        InternalLockManager lockManager = accessor.getStore().getRepository().getLockingManager();
        try {
            try {
                stmtSelect.setString(1, durableLockingID);
                stmtInsertOrDelete.setString(1, durableLockingID);
                stmtUpdate.setString(2, durableLockingID);
                for (Object object : keys) {
                    CDOID id = lockManager.getLockKeyID(object);
                    this.idHandler.setCDOID((PreparedStatement)stmtSelect, 2, id);
                    resultSet = stmtSelect.executeQuery();
                    IDurableLockingManager.LockGrade oldGrade = IDurableLockingManager.LockGrade.NONE;
                    if (resultSet.next()) {
                        oldGrade = IDurableLockingManager.LockGrade.get((int)resultSet.getInt(1));
                    }
                    IDurableLockingManager.LockGrade newGrade = oldGrade.getUpdated(type, on);
                    if (on && oldGrade == IDurableLockingManager.LockGrade.NONE) {
                        this.idHandler.setCDOID((PreparedStatement)stmtInsertOrDelete, 2, id);
                        stmtInsertOrDelete.setInt(3, newGrade.getValue());
                        DBUtil.update((PreparedStatement)stmtInsertOrDelete, (boolean)true);
                        continue;
                    }
                    if (!on && newGrade == IDurableLockingManager.LockGrade.NONE) {
                        this.idHandler.setCDOID((PreparedStatement)stmtInsertOrDelete, 2, id);
                        DBUtil.update((PreparedStatement)stmtInsertOrDelete, (boolean)true);
                        continue;
                    }
                    stmtUpdate.setInt(1, newGrade.getValue());
                    this.idHandler.setCDOID((PreparedStatement)stmtUpdate, 3, id);
                    DBUtil.update((PreparedStatement)stmtUpdate, (boolean)true);
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                throw new DBException((Throwable)sQLException);
            }
        }
        finally {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmtUpdate);
            DBUtil.close((Statement)stmtInsertOrDelete);
            DBUtil.close((Statement)stmtSelect);
        }
    }

    @Override
    public void deleteBranches(IDBStoreAccessor accessor, Batch batch, String idList) {
        batch.add("DELETE FROM CDO_LOCK_AREAS WHERE VIEW_BRANCH IN (" + idList + ")");
        batch.add("DELETE FROM CDO_LOCKS WHERE AREA_ID NOT IN (SELECT ID FROM CDO_LOCK_AREAS WHERE ID=AREA_ID)");
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.lockAreasTable, null, null);
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.locksTable, null, null);
    }

    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        monitor.begin(4.0);
        try {
            DBUtil.update((Connection)connection, (String)this.sqlDeleteLockAreas);
            monitor.worked();
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.lockAreasTable, (OMMonitor)monitor.fork());
            DBUtil.clearTable((Connection)connection, (IDBTable)this.locksTable);
            monitor.worked();
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.locksTable, (OMMonitor)monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    private static void commit(DBStoreAccessor accessor) {
        try {
            IDBConnection connection = accessor.getDBConnection();
            connection.commit();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }
}

