/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorInput;

public final class EditPosition {
    private final IEditorInput fEditorInput;
    private final String fEditorId;
    private final Position fPosition;
    public static final int PROXIMITY_THRESHOLD = 30;

    public EditPosition(IEditorInput editorInput, String editorId, Position pos) {
        Assert.isNotNull((Object)editorInput);
        Assert.isNotNull((Object)editorId);
        this.fEditorId = editorId;
        this.fEditorInput = editorInput;
        this.fPosition = pos;
    }

    public IEditorInput getEditorInput() {
        return this.fEditorInput;
    }

    public String getEditorId() {
        return this.fEditorId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EditPosition [");
        if (this.fEditorInput != null) {
            builder.append("input=");
            builder.append(this.fEditorInput);
            builder.append(", ");
        }
        if (this.fEditorId != null) {
            builder.append("editorId=");
            builder.append(this.fEditorId);
            builder.append(", ");
        }
        if (this.fPosition != null) {
            builder.append("position=");
            builder.append(this.fPosition);
        }
        builder.append("]");
        return builder.toString();
    }

    public Position getPosition() {
        return this.fPosition;
    }

    public static boolean areCoLocated(Position a, Position b, int threshold) {
        int minWithoutOverlap;
        if (a == null || b == null) {
            return false;
        }
        int center1 = a.offset + a.length / 2;
        int center2 = b.offset + b.length / 2;
        int centerDistance = Math.abs(center1 - center2);
        return centerDistance < (minWithoutOverlap = a.length / 2 + b.length / 2) + threshold;
    }

    public static boolean areCoLocated(Position a, Position b) {
        return EditPosition.areCoLocated(a, b, 30);
    }

    public static boolean areCoLocated(EditPosition a, EditPosition b, int threshold) {
        return a != null && b != null && a.getEditorInput().getName().equals(b.getEditorInput().getName()) && EditPosition.areCoLocated(a.getPosition(), b.getPosition(), threshold);
    }

    public static boolean areCoLocated(EditPosition a, EditPosition b) {
        return EditPosition.areCoLocated(a, b, 30);
    }
}

