/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.InteractionRectangleFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CompactLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CrossFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.FullLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.SmallSquareFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.layouts.FillLayout;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TickUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FreeTimeRulerCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionEditPartTN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TickEditPart;

public class CustomFreeTimeRulerCompartmentEditPart
extends FreeTimeRulerCompartmentEditPart {
    public CustomFreeTimeRulerCompartmentEditPart(View view) {
        super(view);
    }

    @Override
    public IFigure createFigure() {
        ResizableCompartmentFigure result = (ResizableCompartmentFigure)super.createFigure();
        result.setTitleVisibility(false);
        result.setBorder(null);
        result.getScrollPane().setBorder(null);
        result.setLayoutManager((LayoutManager)new FreeFormLayoutEx(){

            public void layout(IFigure container) {
                try {
                    CustomFreeTimeRulerCompartmentEditPart.this.layoutTicks(container);
                }
                catch (Exception e) {
                    Activator.log.error("Error in ticks layout", (Throwable)e);
                }
            }
        });
        return result;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        ((ResizableCompartmentFigure)this.getFigure()).getScrollPane().setScrollBarVisibility(0);
        this.refreshBounds();
    }

    public boolean isSelectable() {
        return false;
    }

    protected void layoutTicks(IFigure container) {
        EditPart editPart;
        EditPartViewer viewer = this.getRoot().getViewer();
        Map visualPartMap = viewer.getVisualPartMap();
        InteractionRectangleFigure interactionFigure = (InteractionRectangleFigure)FigureUtils.findParentFigureInstance((IFigure)container, InteractionRectangleFigure.class);
        List osFigures = FigureUtils.findChildFigureInstances((IFigure)interactionFigure, SmallSquareFigure.class);
        List destructionOSFigures = FigureUtils.findChildFigureInstances((IFigure)interactionFigure, CrossFigure.class);
        ArrayList<EditPart> osEditParts = new ArrayList<EditPart>();
        for (PapyrusNodeFigure figure : osFigures) {
            editPart = (EditPart)visualPartMap.get(FigureUtils.findParentFigureInstance((IFigure)figure, BorderedNodeFigure.class));
            if (editPart == null) continue;
            osEditParts.add(editPart);
        }
        for (PapyrusNodeFigure figure : destructionOSFigures) {
            editPart = (EditPart)visualPartMap.get(FigureUtils.findParentFigureInstance((IFigure)figure, BorderedNodeFigure.class));
            if (editPart == null) continue;
            osEditParts.add(editPart);
        }
        if (!(container.getParent().getLayoutManager() instanceof FillLayout)) {
            container.getParent().setLayoutManager((LayoutManager)new FillLayout());
        }
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            List marks = FigureUtils.findChildFigureInstances((IFigure)child, BorderedNodeFigure.class);
            for (BorderedNodeFigure verticalMarkFigure : marks) {
                boolean compactLifeline = FigureUtils.findParentFigureInstance((IFigure)verticalMarkFigure, CompactLifelineFigure.class) != null;
                boolean fullLifeline = FigureUtils.findParentFigureInstance((IFigure)verticalMarkFigure, FullLifelineFigure.class) != null;
                TickEditPart tickEditPart = (TickEditPart)((Object)visualPartMap.get(verticalMarkFigure));
                IGraphicalEditPart occurrenceSpecificationEditPart = TickUtils.findOccurrenceSpecificationEditPartFromTickEditPart(tickEditPart, viewer);
                if (occurrenceSpecificationEditPart == null) continue;
                CompartmentEditPart timelineCompartment = EditPartUtils.findParentTimelineCompartment((EditPart)occurrenceSpecificationEditPart);
                InteractionEditPartTN interactionEditPart = (InteractionEditPartTN)EditPartUtils.findParentEditPartWithId((EditPart)timelineCompartment, "Interaction_Shape");
                int startX = fullLifeline ? 101 : (compactLifeline ? 1 : timelineCompartment.getFigure().getBounds().x - interactionEditPart.getFigure().getBounds().x);
                Dimension markSize = verticalMarkFigure.getPreferredSize();
                IFigure osFigure = occurrenceSpecificationEditPart.getFigure();
                Rectangle osBounds = osFigure.getBounds();
                verticalMarkFigure.setBounds(new Rectangle(startX + osBounds.x - 1, 0, markSize.width, markSize.height));
            }
            ++i;
        }
    }
}

