/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditor;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public class UmlTimingDiagramForMultiEditor
extends UMLDiagramEditor {
    private static final String DIAG_IMG_PATH = "icons/obj16/Diagram_Timing.gif";
    private static final ImageDescriptor DIAG_IMG_DESC = UMLDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/Diagram_Timing.gif");
    private Composite splitter;
    private Image titleImage;

    public UmlTimingDiagramForMultiEditor(ServicesRegistry servicesRegistry, Diagram diagram) throws BackboneException, ServiceException {
        super(servicesRegistry, diagram);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(LabelInternationalization.getInstance().getDiagramLabel(this.getDiagram()));
        this.titleImage = DIAG_IMG_DESC.createImage();
        this.setTitleImage(this.titleImage);
    }

    @Override
    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
            this.titleImage = null;
        }
        super.dispose();
    }

    public void setInput(IEditorInput input) {
        try {
            URIEditorInput uriInput = new URIEditorInput(EcoreUtil.getURI((EObject)this.getDiagram()));
            this.doSetInput((IEditorInput)uriInput, true);
        }
        catch (CoreException x) {
            String title = Messages.UmlTimingDiagramForMultiEditor_editorOpeningErrorTitle;
            String msg = Messages.UmlTimingDiagramForMultiEditor_editorOpeningErrorMessage;
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    protected void createGraphicalViewer(Composite parent) {
        this.splitter = parent;
        super.createGraphicalViewer(parent);
    }

    public void setFocus() {
        this.splitter.setFocus();
        super.setFocus();
    }

    public String getEditingDomainID() {
        return "org.eclipse.papyrus.uml.diagram.timing.EditingDomain";
    }
}

