/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ElementOperations;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.TypeUtil;

public class ModelOperations
extends AbstractContextualOperations {
    static final String CREATE_EMPTY_MODEL_NAME = "createEmptyModel";
    static final String COPY_NAME = "copy";
    static final String OBJECTS_NAME = "objects";
    static final String ROOT_OBJECTS_NAME = "rootObjects";
    static final String OBJECTS_OF_TYPE_NAME = "objectsOfType";
    static final String OBJECTS_OF_KIND_NAME = "objectsOfKind";
    static final String REMOVE_ELEMENT_NAME = "removeElement";
    private static final CallHandler OBJECTS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException(NLS.bind(Messages.InvalidSourceForOperationCall, ModelOperations.OBJECTS_NAME));
            }
            return ModelOperations.getObjects((ModelInstance)source, null, 0, evalEnv);
        }
    };
    private static final CallHandler ROOT_OBJECTS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException(NLS.bind(Messages.InvalidSourceForOperationCall, ModelOperations.ROOT_OBJECTS_NAME));
            }
            LinkedHashSet<EObject> instances = new LinkedHashSet<EObject>();
            ModelInstance model = (ModelInstance)source;
            ModelParameterExtent modelParam = model.getExtent();
            instances.addAll(modelParam.getRootObjects());
            return instances;
        }
    };
    private static final CallHandler OBJECTS_OF_TYPE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException(NLS.bind(Messages.InvalidSourceForOperationCall, ModelOperations.OBJECTS_OF_TYPE_NAME));
            }
            EClassifier type = ElementOperations.getTypeFilterArg(args);
            return ModelOperations.getObjects((ModelInstance)source, type, 1, evalEnv);
        }
    };
    private static final CallHandler OBJECTS_OF_KIND = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException(NLS.bind(Messages.InvalidSourceForOperationCall, ModelOperations.OBJECTS_OF_KIND_NAME));
            }
            EClassifier type = ElementOperations.getTypeFilterArg(args);
            return ModelOperations.getObjects((ModelInstance)source, type, 2, evalEnv);
        }
    };
    private static final CallHandler REMOVE_ELEMENT = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException(NLS.bind(Messages.InvalidSourceForOperationCall, ModelOperations.REMOVE_ELEMENT_NAME));
            }
            ModelInstance model = (ModelInstance)source;
            ModelParameterExtent modelParam = model.getExtent();
            Object elementObject = args[0];
            if (elementObject instanceof EObject) {
                modelParam.removeElement((EObject)elementObject);
            }
            return null;
        }
    };
    private static final CallHandler COPY = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (!(source instanceof ModelInstance)) {
                throw new IllegalArgumentException(NLS.bind(Messages.InvalidSourceForOperationCall, ModelOperations.COPY_NAME));
            }
            ModelInstance model = (ModelInstance)source;
            ModelInstance modelCopy = model.copy();
            evalEnv.addModelExtent(modelCopy.getExtent());
            return modelCopy;
        }
    };
    private static final CallHandler CREATE_EMPTY_MODEL = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof ModelInstance) {
                source = ((ModelInstance)source).eClass();
            }
            if (!(source instanceof ModelType)) {
                throw new IllegalArgumentException(NLS.bind(Messages.InvalidSourceForOperationCall, ModelOperations.CREATE_EMPTY_MODEL_NAME));
            }
            ModelType modelType = (ModelType)source;
            EObject modelObj = modelType.getEPackage().getEFactoryInstance().create((EClass)modelType);
            if (!$assertionsDisabled && !(modelObj instanceof ModelInstance)) {
                throw new AssertionError((Object)"model must implement ModelInstance interface");
            }
            return modelObj;
        }
    };

    public ModelOperations(AbstractQVTStdlib library) {
        super(library, (EClassifier)library.getModelClass());
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary<EClassifier> oclStdlib = this.getStdlib().getOCLStdLib();
        EClassifier setOfElement = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getElementType());
        return new AbstractContextualOperations.OperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "asTransformation", new String[]{"model"}, (EClassifier)this.getStdlib().getTransformationClass(), new EClassifier[]{this.getStdlib().getModelClass()}), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(COPY, COPY_NAME, (EClassifier)oclStdlib.getT(), new EClassifier[0]), this.createOwnedStaticOperationProvider(CREATE_EMPTY_MODEL, CREATE_EMPTY_MODEL_NAME, null, (EClassifier)oclStdlib.getT(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(OBJECTS, OBJECTS_NAME, setOfElement, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(OBJECTS_OF_TYPE, OBJECTS_OF_TYPE_NAME, new String[]{"type"}, (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getOclType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(OBJECTS_OF_KIND, OBJECTS_OF_KIND_NAME, new String[]{"type"}, (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getOclType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(REMOVE_ELEMENT, REMOVE_ELEMENT_NAME, new String[]{"element"}, (EClassifier)oclStdlib.getOclVoid(), this.getStdlib().getElementType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ROOT_OBJECTS, ROOT_OBJECTS_NAME, setOfElement, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(OBJECTS_OF_KIND, "allInstances", (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getOclType()).deprecateBy("Model::objectsOfKind(OclType)")};
    }

    private static Object getObjects(ModelInstance model, EClassifier type, int filterFlag, QvtOperationalEvaluationEnv evalEnv) {
        LinkedHashSet<Object> instances = new LinkedHashSet<Object>();
        ModelParameterExtent modelParam = model.getExtent();
        for (Object obj : modelParam.getAllObjects()) {
            boolean accept;
            boolean bl = accept = filterFlag == 0;
            if (2 == filterFlag) {
                accept = evalEnv.isKindOf(obj, type);
            } else if (1 == filterFlag) {
                accept = evalEnv.isTypeOf(obj, type);
            }
            if (!accept) continue;
            instances.add(obj);
        }
        return instances;
    }
}

