/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CommonsCorePlugin
extends Plugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.commons.core";
    private static CommonsCorePlugin INSTANCE;
    private static final int MAX_CONCURRENT_REQUESTS = 100;
    private static IProxyService proxyService;
    private static ExecutorService service;
    private ServiceTracker tracker;

    public static CommonsCorePlugin getDefault() {
        return INSTANCE;
    }

    public static synchronized ExecutorService getExecutorService() {
        if (service == null) {
            service = new ThreadPoolExecutor(1, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        return service;
    }

    public static synchronized IProxyService getProxyService() {
        if (proxyService == null && INSTANCE != null && CommonsCorePlugin.INSTANCE.tracker != null) {
            return (IProxyService)CommonsCorePlugin.INSTANCE.tracker.getService();
        }
        return proxyService;
    }

    public static synchronized void setProxyService(IProxyService proxyService) {
        CommonsCorePlugin.proxyService = proxyService;
    }

    public CommonsCorePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
        this.tracker = null;
        if (service != null) {
            service.shutdown();
            service = null;
        }
        super.stop(context);
    }
}

