/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEditHelper;
import org.eclipse.ltk.internal.ui.refactoring.history.ShowRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public final class RefactoringPropertyPage
extends PropertyPage {
    private static final String DIALOG_SETTINGS_KEY = "RefactoringPropertyPage";
    static final RefactoringDescriptorProxy[] EMPTY_DESCRIPTORS = new RefactoringDescriptorProxy[0];
    private static final String PREFERENCE_DO_NOT_WARN_DELETE_ALL = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.delete.history";
    private static final String SETTING_SORT = "org.eclipse.ltk.ui.refactoring.sortRefactorings";
    private boolean fHasProjectHistory = false;
    private ShowRefactoringHistoryControl fHistoryControl;
    private IWorkingCopyManager fManager = null;
    private boolean fNewSettings;
    private IDialogSettings fSettings = null;
    private Button fShareHistoryButton = null;

    public RefactoringPropertyPage() {
        this.noDefaultAndApplyButton();
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.fSettings = section;
        }
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IPreferencePageContainer container = this.getContainer();
        this.fManager = container instanceof IWorkbenchPreferenceContainer ? ((IWorkbenchPreferenceContainer)container).getWorkingCopyManager() : new WorkingCopyManager();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fHistoryControl = new ShowRefactoringHistoryControl(composite, new RefactoringHistoryControlConfiguration(this.getCurrentProject(), true, false){

            @Override
            public String getProjectPattern() {
                return RefactoringUIMessages.RefactoringPropertyPage_project_pattern;
            }
        });
        this.fHistoryControl.createControl();
        boolean sortProjects = true;
        IDialogSettings settings = this.fSettings;
        if (settings != null) {
            sortProjects = settings.getBoolean(SETTING_SORT);
        }
        if (sortProjects) {
            this.fHistoryControl.sortByProjects();
        } else {
            this.fHistoryControl.sortByDate();
        }
        this.fHistoryControl.getDeleteAllButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                IProject project = RefactoringPropertyPage.this.getCurrentProject();
                if (project != null) {
                    ProgressMonitorDialog context = new ProgressMonitorDialog(RefactoringPropertyPage.this.getShell());
                    IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
                    MessageDialogWithToggle dialog = null;
                    if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_DELETE_ALL) && !RefactoringPropertyPage.this.fHistoryControl.getInput().isEmpty()) {
                        dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)RefactoringPropertyPage.this.getShell(), (String)RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_all_caption, (String)Messages.format(RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_all_pattern, BasicElementLabels.getResourceName((IResource)project)), (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)false, null, null);
                        store.setValue(PREFERENCE_DO_NOT_WARN_DELETE_ALL, dialog.getToggleState());
                    }
                    if (dialog == null || dialog.getReturnCode() == 2) {
                        RefactoringPropertyPage.this.promptDeleteHistory((IRunnableContext)context, project);
                    }
                }
            }
        });
        this.fHistoryControl.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                RefactoringDescriptorProxy[] selection = RefactoringPropertyPage.this.fHistoryControl.getCheckedDescriptors();
                if (selection.length > 0) {
                    ProgressMonitorDialog context = new ProgressMonitorDialog(RefactoringPropertyPage.this.getShell());
                    IProject project = RefactoringPropertyPage.this.getCurrentProject();
                    if (project != null) {
                        Shell shell = RefactoringPropertyPage.this.getShell();
                        RefactoringHistoryEditHelper.promptRefactoringDelete(shell, (IRunnableContext)context, RefactoringPropertyPage.this.fHistoryControl, new RefactoringDescriptorDeleteQuery(shell, RefactoringPropertyPage.this.getCurrentProject(), selection.length), monitor -> RefactoringHistoryService.getInstance().getProjectHistory(project, monitor), selection);
                    }
                }
            }
        });
        this.fShareHistoryButton = new Button(composite, 32);
        this.fShareHistoryButton.setText(RefactoringUIMessages.RefactoringPropertyPage_share_message);
        this.fShareHistoryButton.setData((Object)"org.eclipse.ltk.core.refactoring.enable.project.refactoring.history");
        GridData data = new GridData(256);
        data.verticalIndent = this.convertHeightInCharsToPixels(1) / 2;
        this.fShareHistoryButton.setLayoutData((Object)data);
        this.fShareHistoryButton.setSelection(this.hasSharedRefactoringHistory());
        new Label(composite, 0);
        IProject project = this.getCurrentProject();
        if (project != null) {
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            this.handleInputEvent((IRunnableContext)context, project);
        }
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.refactoring_property_page");
        return composite;
    }

    private IProject getCurrentProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    private IEclipsePreferences getPreferences(IWorkingCopyManager manager, IScopeContext context) {
        IEclipsePreferences preferences = context.getNode("org.eclipse.ltk.core.refactoring");
        if (manager != null) {
            return manager.getWorkingCopy(preferences);
        }
        return preferences;
    }

    private void handleInputEvent(IRunnableContext context, IProject project) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)project);
        try {
            context.run(false, false, monitor -> {
                IRefactoringHistoryService service = RefactoringCore.getHistoryService();
                try {
                    service.connect();
                    this.fHistoryControl.setInput(service.getProjectHistory(project, monitor));
                }
                finally {
                    service.disconnect();
                }
            });
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean hasSharedRefactoringHistory() {
        IProject project = this.getCurrentProject();
        if (project != null) {
            return RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project);
        }
        return false;
    }

    protected void performDefaults() {
        super.performDefaults();
        IProject project = this.getCurrentProject();
        if (project != null) {
            this.setPreference(this.fManager, (IScopeContext)new ProjectScope(project), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", null);
        }
    }

    public boolean performOk() {
        final IProject project = this.getCurrentProject();
        if (project == null || this.fManager == null) {
            return true;
        }
        if (this.fNewSettings) {
            IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            this.fSettings = section = settings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.fSettings.put(SETTING_SORT, this.fHistoryControl.isSortByProjects());
        this.setPreference(this.fManager, (IScopeContext)new ProjectScope(project), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.toString(this.fShareHistoryButton.getSelection()));
        try {
            this.fManager.applyChanges();
            final boolean history = RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project);
            if (history != this.fHasProjectHistory) {
                Job job = new Job(history ? RefactoringUIMessages.RefactoringPropertyPage_sharing_refactoring_history : RefactoringUIMessages.RefactoringPropertyPage_unsharing_refactoring_history){

                    public final IStatus run(IProgressMonitor monitor) {
                        try {
                            RefactoringHistoryService.setSharedRefactoringHistory((IProject)project, (boolean)history, (IProgressMonitor)monitor);
                        }
                        catch (CoreException exception) {
                            RefactoringUIPlugin.log(exception);
                            return exception.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setRule((ISchedulingRule)project);
                job.setPriority(20);
                job.schedule();
            }
        }
        catch (BackingStoreException exception) {
            RefactoringUIPlugin.log(exception);
        }
        return super.performOk();
    }

    protected void promptDeleteHistory(IRunnableContext context, IProject project) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)project);
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.connect();
            try {
                Shell shell = this.getShell();
                context.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(monitor -> {
                    try {
                        monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, 100);
                        try {
                            service.deleteRefactoringHistory(project, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                        }
                        catch (CoreException exception) {
                            Throwable throwable = exception.getStatus().getException();
                            if (throwable instanceof IOException) {
                                shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage()));
                            }
                            throw exception;
                        }
                        RefactoringHistory history = service.getProjectHistory(project, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                        shell.getDisplay().syncExec(() -> {
                            this.fHistoryControl.setInput(history);
                            this.fHistoryControl.setCheckedDescriptors(EMPTY_DESCRIPTORS);
                        });
                    }
                    finally {
                        monitor.done();
                    }
                }, (ISchedulingRule)project));
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            service.disconnect();
        }
    }

    private void setPreference(IWorkingCopyManager manager, IScopeContext context, String key, String value) {
        IEclipsePreferences preferences = this.getPreferences(manager, context);
        if (value != null) {
            preferences.put(key, value);
        } else {
            preferences.remove(key);
        }
    }

    public void setVisible(boolean visible) {
        this.fHasProjectHistory = this.hasSharedRefactoringHistory();
        super.setVisible(visible);
    }
}

