/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IMultiPageEditorPart;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.ui.IEditorPart;

public class CloseEditorsForViewpointsCommand
extends AbstractCommand {
    private Set<String> allowedEditorIds = new HashSet<String>();
    private Set<Object> pageIdentifiersToClose;

    public CloseEditorsForViewpointsCommand(Collection<MergedArchitectureViewpoint> viewpoints) {
        for (MergedArchitectureViewpoint viewpoint : viewpoints) {
            for (RepresentationKind representationKind : viewpoint.getRepresentationKinds()) {
                if (!(representationKind instanceof PapyrusRepresentationKind)) continue;
                if (representationKind instanceof PapyrusDiagram) {
                    this.allowedEditorIds.add(((PapyrusRepresentationKind)representationKind).getImplementationID());
                    continue;
                }
                if (!(representationKind instanceof PapyrusTable)) continue;
                this.allowedEditorIds.add(((PapyrusRepresentationKind)representationKind).getId());
            }
        }
    }

    public boolean canExecute() {
        IEditorPart activeEditor = EditorHelper.getCurrentEditor();
        return activeEditor instanceof IMultiPageEditorPart;
    }

    public void execute() {
        IPageManager pageManager;
        IEditorPart activeEditor = EditorHelper.getCurrentEditor();
        if (activeEditor instanceof IMultiPageEditorPart && (pageManager = (IPageManager)((IMultiPageEditorPart)activeEditor).getAdapter(IPageManager.class)) != null) {
            this.pageIdentifiersToClose = new HashSet<Object>();
            for (Object object : pageManager.allPages()) {
                if (object instanceof Diagram && !this.allowedEditorIds.contains(((Diagram)object).getType())) {
                    this.pageIdentifiersToClose.add(object);
                    continue;
                }
                if (!(object instanceof Table) || this.allowedEditorIds.contains(((Table)object).getTableKindId())) continue;
                this.pageIdentifiersToClose.add(object);
            }
            if (!this.pageIdentifiersToClose.isEmpty()) {
                this.pageIdentifiersToClose.stream().forEach(pageIdentifier -> pageManager.closePage(pageIdentifier));
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        IPageManager pageManager;
        IEditorPart activeEditor;
        if (this.pageIdentifiersToClose != null && !this.pageIdentifiersToClose.isEmpty() && (activeEditor = EditorHelper.getCurrentEditor()) instanceof IMultiPageEditorPart && (pageManager = (IPageManager)((IMultiPageEditorPart)activeEditor).getAdapter(IPageManager.class)) != null) {
            this.pageIdentifiersToClose.stream().forEach(pageIdentifier -> pageManager.openPage(pageIdentifier));
        }
    }

    public void redo() {
        IPageManager pageManager;
        IEditorPart activeEditor;
        if (this.pageIdentifiersToClose != null && !this.pageIdentifiersToClose.isEmpty() && (activeEditor = EditorHelper.getCurrentEditor()) instanceof IMultiPageEditorPart && (pageManager = (IPageManager)((IMultiPageEditorPart)activeEditor).getAdapter(IPageManager.class)) != null) {
            this.pageIdentifiersToClose.stream().forEach(pageIdentifier -> pageManager.closePage(pageIdentifier));
        }
    }
}

