/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.inject.Injector;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.annotations.IClassAnnotation;

public class CodeConfig
implements IGuiceAwareGeneratorComponent {
    private static final String FILE_HEADER_VAR_TIME = "${time}";
    private static final String FILE_HEADER_VAR_DATE = "${date}";
    private static final String FILE_HEADER_VAR_YEAR = "${year}";
    private static final String FILE_HEADER_VAR_USER = "${user}";
    private static final String FILE_HEADER_VAR_VERSION = "${version}";
    private String encoding = Charset.defaultCharset().name();
    private String lineDelimiter = Strings.newLine();
    private String fileHeader;
    private String fileHeaderTemplate = "/*\n * generated by Xtext\n */";
    private final List<IClassAnnotation> classAnnotations = new ArrayList<IClassAnnotation>();
    private boolean preferXtendStubs = true;
    private XtextVersion xtextVersion;

    public void setFileHeader(String fileHeaderTemplate) {
        this.fileHeaderTemplate = fileHeaderTemplate;
    }

    public void addClassAnnotation(IClassAnnotation annotation) {
        this.classAnnotations.add(annotation);
    }

    @Override
    public void initialize(Injector injector) {
        String fileHeader;
        injector.injectMembers((Object)this);
        this.xtextVersion = XtextVersion.getCurrent();
        if (this.lineDelimiter == null) {
            this.lineDelimiter = "\n";
        }
        if ((fileHeader = this.fileHeaderTemplate) != null) {
            String user;
            if (fileHeader.contains(FILE_HEADER_VAR_TIME)) {
                String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_TIME, time);
            }
            if (fileHeader.contains(FILE_HEADER_VAR_DATE)) {
                String date = new SimpleDateFormat("MMM d, yyyy").format(new Date());
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_DATE, date);
            }
            if (fileHeader.contains(FILE_HEADER_VAR_YEAR)) {
                String year = new SimpleDateFormat("yyyy").format(new Date());
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_YEAR, year);
            }
            if (fileHeader.contains(FILE_HEADER_VAR_USER) && (user = System.getProperty("user.name")) != null) {
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_USER, user);
            }
            if (fileHeader.contains(FILE_HEADER_VAR_VERSION)) {
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_VERSION, this.xtextVersion.toString());
            }
        }
        this.fileHeader = fileHeader;
    }

    public String getClassAnnotationsAsString() {
        if (this.classAnnotations.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            stringBuilder.append(annotation.toString()).append(Strings.newLine());
        }
        return stringBuilder.toString();
    }

    public String getAnnotationImportsAsString() {
        if (this.classAnnotations.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            TypeReference importString = annotation.getAnnotationImport();
            if (importString == null) continue;
            stringBuilder.append("import ").append(importString).append(";").append(Strings.newLine());
        }
        return stringBuilder.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public String getFileHeader() {
        return this.fileHeader;
    }

    public List<IClassAnnotation> getClassAnnotations() {
        return this.classAnnotations;
    }

    public boolean isPreferXtendStubs() {
        return this.preferXtendStubs;
    }

    public void setPreferXtendStubs(boolean preferXtendStubs) {
        this.preferXtendStubs = preferXtendStubs;
    }

    public XtextVersion getXtextVersion() {
        return this.xtextVersion;
    }
}

