/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class RefactoringAnalyzeUtil {
    private RefactoringAnalyzeUtil() {
    }

    public static IRegion[] getNewRanges(TextEdit[] edits, TextChange change) {
        IRegion[] result = new IRegion[edits.length];
        int i = 0;
        while (i < edits.length) {
            result[i] = RefactoringAnalyzeUtil.getNewTextRange(edits[i], change);
            ++i;
        }
        return result;
    }

    public static RefactoringStatus reportProblemNodes(String modifiedWorkingCopySource, SimpleName[] problemNodes) {
        RefactoringStatus result = new RefactoringStatus();
        SimpleName[] simpleNameArray = problemNodes;
        int n = problemNodes.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName problemNode = simpleNameArray[n2];
            JavaStringStatusContext context = new JavaStringStatusContext(modifiedWorkingCopySource, SourceRangeFactory.create((ASTNode)problemNode));
            result.addError(Messages.format(RefactoringCoreMessages.RefactoringAnalyzeUtil_name_collision, BasicElementLabels.getJavaElementName(problemNode.getIdentifier())), (RefactoringStatusContext)context);
            ++n2;
        }
        return result;
    }

    public static LambdaExpression getLambdaExpression(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return ASTNodes.getParent((ASTNode)decl, LambdaExpression.class);
    }

    public static MethodDeclaration getMethodDeclaration(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return ASTNodes.getParent((ASTNode)decl, MethodDeclaration.class);
    }

    public static Block getBlock(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return ASTNodes.getParent((ASTNode)decl, Block.class);
    }

    public static RecordDeclaration getRecordDeclaration(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return ASTNodes.getParent((ASTNode)decl, RecordDeclaration.class);
    }

    public static MethodDeclaration getRecordDeclarationCompactConstructor(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        RecordDeclaration recDecl = RefactoringAnalyzeUtil.getRecordDeclaration(edit, change, cuNode);
        MethodDeclaration compConst = null;
        if (recDecl != null) {
            MethodDeclaration[] decls;
            MethodDeclaration[] methodDeclarationArray = decls = recDecl.getMethods();
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration mDecl = methodDeclarationArray[n2];
                IMethodBinding mBinding = mDecl.resolveBinding();
                if (mBinding != null && mBinding.isCompactConstructor()) {
                    compConst = mDecl;
                    break;
                }
                ++n2;
            }
        }
        return compConst;
    }

    public static IProblem[] getIntroducedCompileProblems(CompilationUnit newCUNode, CompilationUnit oldCuNode) {
        IProblem[] newProblems;
        HashSet<IProblem> subResult = new HashSet<IProblem>();
        Set<IProblem> oldProblems = RefactoringAnalyzeUtil.getOldProblems(oldCuNode);
        IProblem[] iProblemArray = newProblems = ASTNodes.getProblems((ASTNode)newCUNode, 2, 7);
        int n = newProblems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem newProblem = iProblemArray[n2];
            IProblem correspondingOld = RefactoringAnalyzeUtil.findCorrespondingProblem(oldProblems, newProblem);
            if (correspondingOld == null) {
                subResult.add(newProblem);
            }
            ++n2;
        }
        return subResult.toArray(new IProblem[subResult.size()]);
    }

    public static RefactoringStatus checkNewSource(CompilationUnitChange change, ICompilationUnit originalCu, CompilationUnit oldCuNode, IProgressMonitor pm) throws CoreException {
        IProblem[] newProblems;
        RefactoringStatus result = new RefactoringStatus();
        String newCuSource = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit newCuNode = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse(newCuSource, originalCu, true, true, pm);
        IProblem[] iProblemArray = newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCuNode, oldCuNode);
        int n = newProblems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                result.addEntry(new RefactoringStatusEntry(3, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, SourceRangeFactory.create(problem))));
            }
            ++n2;
        }
        return result;
    }

    public static IRegion getNewTextRange(TextEdit edit, TextChange change) {
        return change.getPreviewEdit(edit).getRegion();
    }

    private static IProblem findCorrespondingProblem(Set<IProblem> oldProblems, IProblem iProblem) {
        for (IProblem oldProblem : oldProblems) {
            if (!RefactoringAnalyzeUtil.isCorresponding(oldProblem, iProblem)) continue;
            return oldProblem;
        }
        return null;
    }

    private static boolean isCorresponding(IProblem oldProblem, IProblem iProblem) {
        if (oldProblem.getID() != iProblem.getID()) {
            return false;
        }
        return oldProblem.getMessage().equals(iProblem.getMessage());
    }

    private static SimpleName getSimpleName(ASTNode node) {
        if (node instanceof SimpleName) {
            return (SimpleName)node;
        }
        if (node instanceof VariableDeclaration) {
            return ((VariableDeclaration)node).getName();
        }
        return null;
    }

    private static SimpleName findSimpleNameNode(IRegion range, CompilationUnit cuNode) {
        ASTNode node = NodeFinder.perform((ASTNode)cuNode, (int)range.getOffset(), (int)range.getLength());
        return RefactoringAnalyzeUtil.getSimpleName(node);
    }

    private static Set<IProblem> getOldProblems(CompilationUnit oldCuNode) {
        return new HashSet<IProblem>(Arrays.asList(ASTNodes.getProblems((ASTNode)oldCuNode, 2, 7)));
    }
}

