/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class RedundantComparatorFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<RedundantComparatorFixOperation> operations = new ArrayList<RedundantComparatorFixOperation>();
        RedundantComparatorFinder finder = new RedundantComparatorFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new RedundantComparatorFixCore(FixMessages.RedundantComparatorFix_remove_comparator, compilationUnit, ops);
    }

    protected RedundantComparatorFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class RedundantComparatorFinder
    extends ASTVisitor {
        private List<RedundantComparatorFixOperation> fResult;

        public RedundantComparatorFinder(List<RedundantComparatorFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(MethodInvocation visited) {
            IMethodBinding methodBinding = visited.resolveMethodBinding();
            if (methodBinding != null) {
                if (methodBinding.getParameterTypes().length == 2 && ASTNodes.hasType(methodBinding.getDeclaringClass(), Collections.class.getCanonicalName()) && ("sort".equals(visited.getName().getIdentifier()) && ASTNodes.hasType(methodBinding.getParameterTypes()[0], List.class.getCanonicalName()) || Arrays.asList("max", "min").contains(visited.getName().getIdentifier()) && ASTNodes.hasType(methodBinding.getParameterTypes()[0], Collection.class.getCanonicalName())) && ASTNodes.hasType(methodBinding.getParameterTypes()[1], Comparator.class.getCanonicalName())) {
                    List args = visited.arguments();
                    return this.maybeRefactorCode(null, (Expression)args.get(0), (Expression)args.get(1));
                }
                if (visited.getExpression() != null && methodBinding.getParameterTypes().length == 1 && "sort".equals(visited.getName().getIdentifier()) && ASTNodes.hasType(methodBinding.getDeclaringClass(), List.class.getCanonicalName()) && ASTNodes.hasType(methodBinding.getParameterTypes()[0], Comparator.class.getCanonicalName())) {
                    List args = visited.arguments();
                    return this.maybeRefactorCode(visited, visited.getExpression(), (Expression)args.get(0));
                }
            }
            return true;
        }

        private boolean maybeRefactorCode(MethodInvocation visitedIfRefactoringNeeded, Expression list, Expression comparator) {
            ITypeBinding[] typeArguments;
            if (list.resolveTypeBinding() != null && (typeArguments = list.resolveTypeBinding().getTypeArguments()) != null && typeArguments.length == 1 && this.isComparable(typeArguments[0])) {
                return this.maybeRefactorTypedCode(visitedIfRefactoringNeeded, list, comparator, comparator, typeArguments, true);
            }
            return true;
        }

        private boolean maybeRefactorTypedCode(MethodInvocation visitedIfRefactoringNeeded, Expression list, Expression comparatorToRemove, Expression comparatorToAnalyze, ITypeBinding[] typeArguments, boolean isForward) {
            NullLiteral nullLiteral = ASTNodes.as(comparatorToAnalyze, NullLiteral.class);
            if (nullLiteral != null) {
                return this.maybeRemoveComparator(visitedIfRefactoringNeeded, list, comparatorToRemove, isForward);
            }
            ClassInstanceCreation classInstanceCreation = ASTNodes.as(comparatorToAnalyze, ClassInstanceCreation.class);
            if (classInstanceCreation != null && this.isClassToRemove(classInstanceCreation, isForward)) {
                return this.maybeRemoveComparator(visitedIfRefactoringNeeded, list, comparatorToRemove, true);
            }
            MethodReference methodReference = ASTNodes.as(comparatorToAnalyze, MethodReference.class);
            LambdaExpression lambdaExpression = ASTNodes.as(comparatorToAnalyze, LambdaExpression.class);
            MethodInvocation methodInvocation = ASTNodes.as(comparatorToAnalyze, MethodInvocation.class);
            if (methodReference != null) {
                String elementClass;
                String string = elementClass = typeArguments[0].isWildcardType() ? Comparable.class.getCanonicalName() : typeArguments[0].getQualifiedName();
                if (ASTNodes.usesGivenSignature(methodReference.resolveMethodBinding(), elementClass, "compareTo", Object.class.getCanonicalName())) {
                    return this.maybeRemoveComparator(visitedIfRefactoringNeeded, list, comparatorToRemove, isForward);
                }
            } else if (methodInvocation != null) {
                if (ASTNodes.usesGivenSignature(methodInvocation, Comparator.class.getCanonicalName(), "reversed", new String[0]) && methodInvocation.getExpression() != null) {
                    return this.maybeRefactorTypedCode(visitedIfRefactoringNeeded, list, comparatorToRemove, methodInvocation.getExpression(), typeArguments, !isForward);
                }
                if (ASTNodes.usesGivenSignature(methodInvocation, Comparator.class.getCanonicalName(), "naturalOrder", new String[0])) {
                    return this.maybeRemoveComparator(visitedIfRefactoringNeeded, list, comparatorToRemove, isForward);
                }
                if ("comparing".equals(methodInvocation.getName().getIdentifier()) && methodInvocation.resolveMethodBinding() != null && methodInvocation.resolveMethodBinding().getParameterTypes().length == 1 && ASTNodes.hasType(methodInvocation.resolveMethodBinding().getDeclaringClass(), Comparator.class.getCanonicalName()) && ASTNodes.hasType(methodInvocation.resolveMethodBinding().getParameterTypes()[0], Function.class.getCanonicalName())) {
                    List comparingMethodArgs = methodInvocation.arguments();
                    Expression criteria = (Expression)comparingMethodArgs.get(0);
                    LambdaExpression comparingMethodLambdaExpression = ASTNodes.as(criteria, LambdaExpression.class);
                    MethodInvocation identityMethod = ASTNodes.as(criteria, MethodInvocation.class);
                    if (comparingMethodLambdaExpression != null) {
                        if (comparingMethodLambdaExpression.parameters().size() == 1) {
                            List parameters = comparingMethodLambdaExpression.parameters();
                            SimpleName variable = ((VariableDeclaration)parameters.get(0)).getName();
                            Expression bodyExpression = null;
                            if (comparingMethodLambdaExpression.getBody() instanceof Block) {
                                ReturnStatement returnStatement = ASTNodes.as((Statement)((Block)comparingMethodLambdaExpression.getBody()), ReturnStatement.class);
                                if (returnStatement == null) {
                                    return true;
                                }
                                bodyExpression = returnStatement.getExpression();
                            } else if (comparingMethodLambdaExpression.getBody() instanceof Expression) {
                                bodyExpression = (Expression)comparingMethodLambdaExpression.getBody();
                            } else {
                                return true;
                            }
                            if (ASTNodes.areSameVariables((ASTNode)variable, new ASTNode[]{bodyExpression})) {
                                return this.maybeRemoveComparator(visitedIfRefactoringNeeded, list, comparatorToRemove, isForward);
                            }
                        }
                    } else if (identityMethod != null && "identity".equals(identityMethod.getName().getIdentifier()) && identityMethod.resolveMethodBinding() != null && identityMethod.resolveMethodBinding().getParameterTypes().length == 0 && ASTNodes.hasType(identityMethod.resolveMethodBinding().getDeclaringClass(), Function.class.getCanonicalName())) {
                        return this.maybeRemoveComparator(visitedIfRefactoringNeeded, list, comparatorToRemove, isForward);
                    }
                }
            } else if (lambdaExpression != null && lambdaExpression.parameters().size() == 2) {
                SimpleName variable2;
                SimpleName variable1;
                List parameters = lambdaExpression.parameters();
                ASTNode parameter1 = (ASTNode)parameters.get(0);
                ASTNode parameter2 = (ASTNode)parameters.get(1);
                if (parameter1 instanceof SingleVariableDeclaration) {
                    variable1 = ((SingleVariableDeclaration)parameter1).getName();
                } else if (parameter1 instanceof VariableDeclarationFragment) {
                    variable1 = ((VariableDeclarationFragment)parameter1).getName();
                } else {
                    return true;
                }
                if (parameter2 instanceof SingleVariableDeclaration) {
                    variable2 = ((SingleVariableDeclaration)parameter2).getName();
                } else if (parameter2 instanceof VariableDeclarationFragment) {
                    variable2 = ((VariableDeclarationFragment)parameter2).getName();
                } else {
                    return true;
                }
                Expression bodyExpression = null;
                if (lambdaExpression.getBody() instanceof Block) {
                    ReturnStatement returnStatement = ASTNodes.as((Statement)((Block)lambdaExpression.getBody()), ReturnStatement.class);
                    if (returnStatement == null) {
                        return true;
                    }
                    bodyExpression = returnStatement.getExpression();
                } else if (lambdaExpression.getBody() instanceof Expression) {
                    bodyExpression = (Expression)lambdaExpression.getBody();
                } else {
                    return true;
                }
                if (this.isReturnedExpressionToRemove(variable1, variable2, bodyExpression, isForward)) {
                    return this.maybeRemoveComparator(visitedIfRefactoringNeeded, list, comparatorToRemove, true);
                }
            }
            return true;
        }

        private boolean isComparable(ITypeBinding classBinding) {
            if ("java.lang.Comparable".equals(classBinding.getErasure().getQualifiedName())) {
                return true;
            }
            ITypeBinding superClass = classBinding.getSuperclass();
            if (superClass != null && this.isComparable(superClass)) {
                return true;
            }
            ITypeBinding[] iTypeBindingArray = classBinding.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding binding = iTypeBindingArray[n2];
                if (this.isComparable(binding)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean isClassToRemove(ClassInstanceCreation classInstanceCreation, boolean isForward) {
            AnonymousClassDeclaration anonymousClassDecl = classInstanceCreation.getAnonymousClassDeclaration();
            Type type = classInstanceCreation.getType();
            if (type != null && type.resolveBinding() != null && type.resolveBinding().getTypeArguments() != null && type.resolveBinding().getTypeArguments().length == 1 && ASTNodes.hasType(type.resolveBinding(), Comparator.class.getCanonicalName()) && classInstanceCreation.arguments().isEmpty() && anonymousClassDecl != null) {
                MethodDeclaration methodDecl;
                ReturnStatement returnStatement;
                BodyDeclaration body;
                List bodies = anonymousClassDecl.bodyDeclarations();
                ITypeBinding typeArgument = type.resolveBinding().getTypeArguments()[0];
                if (bodies != null && bodies.size() == 1 && typeArgument != null && (body = (BodyDeclaration)bodies.get(0)) instanceof MethodDeclaration && (returnStatement = ASTNodes.as((Statement)(methodDecl = (MethodDeclaration)body).getBody(), ReturnStatement.class)) != null && returnStatement.getExpression() != null && ASTNodes.usesGivenSignature(methodDecl, Comparator.class.getCanonicalName(), "compare", typeArgument.getQualifiedName(), typeArgument.getQualifiedName())) {
                    VariableDeclaration object1 = (VariableDeclaration)methodDecl.parameters().get(0);
                    VariableDeclaration object2 = (VariableDeclaration)methodDecl.parameters().get(1);
                    return this.isReturnedExpressionToRemove(object1.getName(), object2.getName(), returnStatement.getExpression(), isForward);
                }
            }
            return false;
        }

        private boolean isReturnedExpressionToRemove(SimpleName name1, SimpleName name2, Expression returnExpression, boolean isForward) {
            ITypeBinding comparisonType;
            PrefixExpression negativeExpression = ASTNodes.as(returnExpression, PrefixExpression.class);
            if (negativeExpression != null && ASTNodes.hasOperator(negativeExpression, PrefixExpression.Operator.MINUS, new PrefixExpression.Operator[0])) {
                return this.isReturnedExpressionToRemove(name1, name2, negativeExpression.getOperand(), !isForward);
            }
            MethodInvocation compareToMethod = ASTNodes.as(returnExpression, MethodInvocation.class);
            if (compareToMethod != null && compareToMethod.getExpression() != null && (comparisonType = compareToMethod.getExpression().resolveTypeBinding()) != null) {
                List arguments = compareToMethod.arguments();
                if (compareToMethod.getExpression() != null && ASTNodes.usesGivenSignature(compareToMethod, comparisonType.getQualifiedName(), "compareTo", comparisonType.getQualifiedName())) {
                    return this.isRefactorComparisonToRefactor(name1, name2, compareToMethod.getExpression(), (Expression)arguments.get(0), isForward);
                }
                String primitiveType = Bindings.getUnboxedTypeName(comparisonType.getQualifiedName());
                if (primitiveType != null && ASTNodes.usesGivenSignature(compareToMethod, comparisonType.getQualifiedName(), "compare", primitiveType, primitiveType)) {
                    return this.isRefactorComparisonToRefactor(name1, name2, (Expression)arguments.get(0), (Expression)arguments.get(1), isForward);
                }
            }
            return false;
        }

        private boolean isRefactorComparisonToRefactor(SimpleName name1, SimpleName name2, Expression expression1, Expression expression2, boolean isForward) {
            if (isForward && ASTNodes.isSameVariable((ASTNode)name1, (ASTNode)expression1) && ASTNodes.isSameVariable((ASTNode)name2, (ASTNode)expression2)) {
                return true;
            }
            return !isForward && ASTNodes.isSameVariable((ASTNode)name1, (ASTNode)expression2) && ASTNodes.isSameVariable((ASTNode)name2, (ASTNode)expression1);
        }

        private boolean maybeRemoveComparator(MethodInvocation visitedIfRefactoringNeeded, Expression list, Expression comparatorToRemove, boolean isForward) {
            if (isForward) {
                this.fResult.add(new RedundantComparatorFixOperation(visitedIfRefactoringNeeded, list, comparatorToRemove));
                return false;
            }
            return true;
        }
    }

    public static class RedundantComparatorFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final MethodInvocation visitedIfRefactoringNeeded;
        private final Expression list;
        private final Expression comparator;

        public RedundantComparatorFixOperation(MethodInvocation visitedIfRefactoringNeeded, Expression list, Expression comparator) {
            this.visitedIfRefactoringNeeded = visitedIfRefactoringNeeded;
            this.list = list;
            this.comparator = comparator;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.RedundantComparatorCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            if (this.visitedIfRefactoringNeeded != null) {
                String collectionsNameText = importRewrite.addImport(Collections.class.getCanonicalName());
                MethodInvocation sortMethod = ast.newMethodInvocation();
                sortMethod.setExpression((Expression)ASTNodeFactory.newName(ast, collectionsNameText));
                sortMethod.setName(ast.newSimpleName("sort"));
                sortMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.list)));
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visitedIfRefactoringNeeded, (ASTNode)sortMethod, group);
            } else {
                ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.comparator, group);
            }
        }
    }
}

