/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container.delegate;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.delegate.ContainerQueue;
import org.eclipse.net4j.util.container.delegate.IContainerBlockingQueue;
import org.eclipse.net4j.util.event.IListener;

public class ContainerBlockingQueue<E>
extends ContainerQueue<E>
implements IContainerBlockingQueue<E> {
    public ContainerBlockingQueue(BlockingQueue<E> delegate) {
        super(delegate);
    }

    @Override
    public BlockingQueue<E> getDelegate() {
        return (BlockingQueue)super.getDelegate();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        int drainTo = this.getDelegate().drainTo(c);
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent(this.createEvent(c, IContainerDelta.Kind.REMOVED), listeners);
        }
        return drainTo;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int drainTo = this.getDelegate().drainTo(c, maxElements);
        this.fireEvent(this.createEvent(c, IContainerDelta.Kind.REMOVED));
        return drainTo;
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        boolean modified = this.getDelegate().offer(o, timeout, unit);
        if (modified) {
            this.fireAddedEvent(o);
        }
        return modified;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object removed = this.getDelegate().poll(timeout, unit);
        if (removed != null) {
            this.fireRemovedEvent(removed);
        }
        return removed;
    }

    @Override
    public void put(E o) throws InterruptedException {
        this.getDelegate().put(o);
        this.fireAddedEvent(o);
    }

    @Override
    public int remainingCapacity() {
        return this.getDelegate().remainingCapacity();
    }

    @Override
    public E take() throws InterruptedException {
        Object element = this.getDelegate().take();
        this.fireRemovedEvent(element);
        return element;
    }
}

