/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;

public class StateInvariantResizableEditPolicy
extends BorderItemResizableEditPolicy {
    protected Command getResizeCommand(ChangeBoundsRequest request) {
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator != null) {
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            this.getHostFigure().translateToRelative((Translatable)rect);
            Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
            if (borderItemEP.getParent() instanceof LifelineEditPart && !this.restrictInParentBounds((LifelineEditPart)borderItemEP.getParent(), borderItemEP, realLocation.getCopy())) {
                return null;
            }
            SetResizeAndLocationCommand moveCommand = new SetResizeAndLocationCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), realLocation);
            return new ICommandProxy((ICommand)moveCommand);
        }
        return null;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator != null) {
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            this.getHostFigure().translateToRelative((Translatable)rect);
            Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
            if (borderItemEP.getParent() instanceof LifelineEditPart && !this.restrictInParentBounds((LifelineEditPart)borderItemEP.getParent(), borderItemEP, realLocation.getCopy())) {
                return null;
            }
            Point location = realLocation.getTopLeft();
            SetLocationCommand moveCommand = new SetLocationCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
            return new ICommandProxy((ICommand)moveCommand);
        }
        return null;
    }

    private boolean restrictInParentBounds(LifelineEditPart ep, IBorderItemEditPart borderItemEP, Rectangle realLocation) {
        borderItemEP.getFigure().translateToAbsolute((Translatable)realLocation);
        Rectangle bounds = ep.getPrimaryShape().getBounds().getCopy();
        ep.getPrimaryShape().translateToAbsolute((Translatable)bounds);
        return true;
    }
}

