/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.util.UtilMessages;

public class VMUtil {
    public static IVMInstall[] getAllVMInstances() {
        IVMInstallType[] types;
        ArrayList res = new ArrayList();
        IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] installs = type.getVMInstalls();
            Collections.addAll(res, installs);
            ++n2;
        }
        return res.toArray(new IVMInstall[res.size()]);
    }

    public static String[] getVMInstallNames() {
        IVMInstall[] installs = VMUtil.getAllVMInstances();
        String[] names = new String[installs.length];
        int i = 0;
        while (i < installs.length) {
            names[i] = installs[i].getName();
            ++i;
        }
        return names;
    }

    public static String getDefaultVMInstallName() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getName();
        }
        return "";
    }

    public static String getDefaultVMInstallLocation() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getInstallLocation().getAbsolutePath();
        }
        return null;
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs;
            IVMInstall[] iVMInstallArray = installs = VMUtil.getAllVMInstances();
            int n = installs.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall install = iVMInstallArray[n2];
                if (install.getName().equals(name)) {
                    return install;
                }
                ++n2;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static IExecutionEnvironment[] getExecutionEnvironments() {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        return manager.getExecutionEnvironments();
    }

    public static IExecutionEnvironment getExecutionEnvironment(String id) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        return manager.getEnvironment(id);
    }

    public static String getVMInstallName(IExecutionEnvironment ee) throws CoreException {
        IPath containerPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee);
        IVMInstall vmi = JavaRuntime.getVMInstall((IPath)containerPath);
        if (vmi == null) {
            throw new CoreException(VMUtil.createErrorStatus(NLS.bind((String)UtilMessages.VMHelper_noJreForExecEnv, (Object)ee.getId())));
        }
        return vmi.getName();
    }

    public static IStatus createErrorStatus(String message) {
        return Status.error((String)message, null);
    }
}

