/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.plugin;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.UpdateManagerHelperDeprecated;
import org.eclipse.pde.internal.core.target.TargetPlatformService;

public class TargetPlatform {
    private static String PRODUCT_PROPERTY = "eclipse.product";
    private static String APPLICATION_PROPERTY = "eclipse.application";
    private static String SDK_PRODUCT = "org.eclipse.sdk.ide";
    private static String PLATFORM_PRODUCT = "org.eclipse.platform.ide";
    private static String IDE_APPLICATION = "org.eclipse.ui.ide.workbench";

    public static String getLocation() {
        try {
            ITargetDefinition target = TargetPlatformService.getDefault().getWorkspaceTargetDefinition();
            ITargetLocation[] containers = target.getTargetLocations();
            String path = null;
            if (containers != null && containers.length > 0 && (path = containers[0].getLocation(true)) != null) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                path = manager.performStringSubstitution(path);
                return path;
            }
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        return TargetPlatform.getDefaultLocation();
    }

    public static String getDefaultLocation() {
        Location location = Platform.getInstallLocation();
        if (location != null) {
            URL url = Platform.getInstallLocation().getURL();
            IPath path = new Path(url.getFile()).removeTrailingSeparator();
            return path.toOSString();
        }
        return "";
    }

    public static String getOS() {
        return TargetPlatform.getTargetProperty(ITargetDefinition::getOS, Platform::getOS);
    }

    public static String getWS() {
        return TargetPlatform.getTargetProperty(ITargetDefinition::getWS, Platform::getWS);
    }

    public static String getNL() {
        return TargetPlatform.getTargetProperty(ITargetDefinition::getNL, Platform::getNL);
    }

    public static String getOSArch() {
        return TargetPlatform.getTargetProperty(ITargetDefinition::getArch, Platform::getOSArch);
    }

    private static String getTargetProperty(Function<ITargetDefinition, String> getter, Supplier<String> defaultValue) {
        try {
            ITargetDefinition target = TargetPlatformService.getDefault().getWorkspaceTargetDefinition();
            String result = getter.apply(target);
            if (result != null) {
                return result;
            }
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        return defaultValue.get();
    }

    public static String[] getApplications() {
        return TargetPlatformHelper.getApplicationNames();
    }

    public static String[] getProducts() {
        return TargetPlatformHelper.getProductNames();
    }

    public static String getDefaultProduct() {
        String product;
        Properties config = TargetPlatformHelper.getConfigIniProperties();
        TreeSet<String> set = TargetPlatformHelper.getProductNameSet();
        if (config != null && (product = (String)config.get(PRODUCT_PROPERTY)) != null && set.contains(product)) {
            return product;
        }
        if (set.contains(SDK_PRODUCT)) {
            return SDK_PRODUCT;
        }
        return set.contains(PLATFORM_PRODUCT) ? PLATFORM_PRODUCT : null;
    }

    public static String getDefaultApplication() {
        String application;
        Properties config = TargetPlatformHelper.getConfigIniProperties();
        Set<String> set = TargetPlatformHelper.getApplicationNameSet();
        if (config != null && (application = (String)config.get(APPLICATION_PROPERTY)) != null && set.contains(application)) {
            return application;
        }
        return IDE_APPLICATION;
    }

    @Deprecated
    public static void createPlatformConfiguration(File location, IPluginModelBase[] plugins, IPluginModelBase brandingPlugin) throws CoreException {
        UpdateManagerHelperDeprecated.createPlatformConfiguration(location, plugins, brandingPlugin);
    }

    public static String getBundleList() {
        return TargetPlatformHelper.getBundleList();
    }
}

