/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.resourceloading.profile;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.modelsetquery.IFillableModelSetQueryAdapter;
import org.eclipse.papyrus.infra.core.modelsetquery.IModelSetQueryAdapter;
import org.eclipse.papyrus.infra.core.modelsetquery.impl.ModelSetQueryInitializer;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.resourceloading.ILoadingStrategyExtension;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLProfileStrategyExtension
implements ILoadingStrategyExtension {
    public boolean loadResource(ModelSet modelSet, URI uri) {
        Resource modelResource = UmlUtils.getUmlModel((ModelSet)modelSet).getResource();
        if (modelResource != null && "uml".equals(modelResource.getURI().fileExtension())) {
            IModelSetQueryAdapter anAdapter;
            IFillableModelSetQueryAdapter adapter = null;
            for (Adapter a : modelSet.eAdapters()) {
                if (!(a instanceof IFillableModelSetQueryAdapter)) continue;
                adapter = (IFillableModelSetQueryAdapter)a;
                break;
            }
            if (adapter == null && (anAdapter = ModelSetQueryInitializer.createDefaultIModelSetQueryAdapter()) instanceof IFillableModelSetQueryAdapter) {
                modelSet.eAdapters().add((Object)((Adapter)anAdapter));
            }
            if (!modelResource.getContents().isEmpty() && adapter != null) {
                Collection applications = null;
                if (!adapter.isAlreadyComputed((EClassifier)UMLPackage.Literals.PROFILE_APPLICATION)) {
                    applications = new HashSet();
                    int i = 0;
                    while (i < modelSet.getResources().size()) {
                        TreeIterator j = EcoreUtil.getAllProperContents((Resource)((Resource)modelSet.getResources().get(i)), (boolean)false);
                        while (j.hasNext()) {
                            EObject e = (EObject)j.next();
                            if (e instanceof Package) {
                                applications.addAll(((Package)e).getProfileApplications());
                                continue;
                            }
                            j.prune();
                        }
                        ++i;
                    }
                    adapter.addEntriesInCache((EClassifier)UMLPackage.Literals.PROFILE_APPLICATION, (HashSet)applications);
                } else {
                    applications = adapter.getReachableObjectsOfType((EObject)modelResource.getContents().get(0), (EClassifier)UMLPackage.Literals.PROFILE_APPLICATION);
                }
                if (applications != null) {
                    for (EObject profileApp : applications) {
                        InternalEObject internal;
                        EObject profile = (EObject)profileApp.eGet((EStructuralFeature)UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE, false);
                        if (profile == null) continue;
                        URI trimFragment = uri.trimFragment();
                        if (!(profile.eIsProxy() ? trimFragment.equals((internal = (InternalEObject)profile).eProxyURI().trimFragment()) : profile instanceof Profile && trimFragment.equals(((Profile)profile).eResource().getURI().trimFragment()))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

