/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.IUriSchemeExtensionReader;

public class AutoRegisterSchemeHandlersJob
extends Job {
    private static final String SKIP_PREFERENCE = "skipAutoRegistration";
    private static final String PROCESSED_SCHEMES_PREFERENCE = "processedSchemes";
    private static final String SCHEME_LIST_PREFERENCE_SEPARATOR = ",";
    private static boolean alreadyTriggered = false;
    private IEclipsePreferences testPreferenceNode;
    private IUriSchemeExtensionReader testExtensionReader;
    private IOperatingSystemRegistration testOsRegistration;

    public AutoRegisterSchemeHandlersJob() {
        this(null, null, null);
    }

    AutoRegisterSchemeHandlersJob(IEclipsePreferences testPreferenceNode, IUriSchemeExtensionReader testExtensionReader, IOperatingSystemRegistration testOsRegistration) {
        super(AutoRegisterSchemeHandlersJob.class.getSimpleName());
        this.testPreferenceNode = testPreferenceNode;
        this.testExtensionReader = testExtensionReader;
        this.testOsRegistration = testOsRegistration;
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IUriSchemeExtensionReader extensionReader = this.testExtensionReader != null ? this.testExtensionReader : IUriSchemeExtensionReader.newInstance();
        IPreferencesService preferences = Platform.getPreferencesService();
        String schemes = this.testPreferenceNode != null ? this.testPreferenceNode.get(PROCESSED_SCHEMES_PREFERENCE, "") : preferences.getString("org.eclipse.urischeme", PROCESSED_SCHEMES_PREFERENCE, "", null);
        LinkedHashSet<String> processedSchemes = new LinkedHashSet<String>(Arrays.asList(schemes.split(SCHEME_LIST_PREFERENCE_SEPARATOR)));
        Collection<IScheme> toProcessSchemes = new LinkedHashSet<IScheme>(extensionReader.getSchemes());
        toProcessSchemes.removeIf(scheme -> processedSchemes.contains(scheme.getName()));
        if (toProcessSchemes.isEmpty()) {
            alreadyTriggered = true;
            return Status.OK_STATUS;
        }
        IOperatingSystemRegistration osRegistration = this.testOsRegistration != null ? this.testOsRegistration : IOperatingSystemRegistration.getInstance();
        try {
            toProcessSchemes = osRegistration.getSchemesInformation(toProcessSchemes).stream().filter(scheme -> !scheme.schemeIsHandledByOther()).collect(Collectors.toSet());
            if (toProcessSchemes.isEmpty()) {
                alreadyTriggered = true;
                return Status.OK_STATUS;
            }
            osRegistration.handleSchemes(toProcessSchemes, Collections.emptyList());
            processedSchemes.addAll(toProcessSchemes.stream().map(IScheme::getName).collect(Collectors.toList()));
            IEclipsePreferences preferenceNode = this.testPreferenceNode != null ? this.testPreferenceNode : InstanceScope.INSTANCE.getNode("org.eclipse.urischeme");
            preferenceNode.put(PROCESSED_SCHEMES_PREFERENCE, processedSchemes.stream().collect(Collectors.joining(SCHEME_LIST_PREFERENCE_SEPARATOR)));
            preferenceNode.flush();
            alreadyTriggered = true;
        }
        catch (Exception e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        return !alreadyTriggered && !Platform.getPreferencesService().getBoolean("org.eclipse.urischeme", SKIP_PREFERENCE, false, null);
    }
}

