/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IIdAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.OperationIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLOperationAxisManager;
import org.eclipse.papyrus.uml.nattable.provider.UMLStereotypeRestrictedOperationContentProvider;
import org.eclipse.papyrus.uml.nattable.utils.StereotypeOperationUtils;
import org.eclipse.papyrus.uml.tools.util.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class UMLStereotypeOperationAxisManager
extends UMLOperationAxisManager
implements IIdAxisManager {
    @Override
    public boolean isAllowedContents(Object object) {
        Operation operation;
        Element owner;
        boolean result = false;
        if (object instanceof Operation && (owner = (operation = (Operation)object).getOwner()) instanceof Stereotype) {
            while (owner.getOwner() instanceof Package && !result) {
                owner = owner.getOwner();
                result = owner instanceof Profile;
            }
            if (result) {
                result = EMFHelper.isReadOnly((EObject)operation);
            }
        }
        return result;
    }

    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        Set<Object> operationsToAdd = this.getOperationToAdd(objectToAdd);
        if (!operationsToAdd.isEmpty()) {
            return this.getAddAxisCommand(domain, operationsToAdd);
        }
        return null;
    }

    protected Set<Object> getOperationToAdd(Collection<Object> objectToAdd) {
        HashSet appliedStereotypes = new HashSet();
        for (Object current : objectToAdd) {
            if (!(current instanceof Element)) continue;
            appliedStereotypes.addAll(((Element)current).getAppliedStereotypes());
        }
        HashSet<Object> operationToAdd = new HashSet<Object>();
        for (Stereotype stereotype : appliedStereotypes) {
            operationToAdd.addAll(StereotypeUtil.getAllStereotypeOperations((Stereotype)stereotype, (boolean)true, (boolean)true, (boolean)true));
        }
        return operationToAdd;
    }

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        Collection<IAxis> toAdd = this.getAxisToAdd(objectToAdd);
        if (!toAdd.isEmpty()) {
            return new AbstractAxisManager.AddCommandWrapper((AbstractAxisManager)this, AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd), objectToAdd);
        }
        return null;
    }

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        Collection<IAxis> toAdd = this.getAxisToAdd(objectToAdd);
        if (!toAdd.isEmpty()) {
            return new AbstractAxisManager.AddCommandWrapper((AbstractAxisManager)this, AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd, (int)index), objectToAdd);
        }
        return null;
    }

    protected Collection<IAxis> getAxisToAdd(Collection<Object> objectToAdd) {
        ArrayList<IAxis> toAdd = new ArrayList<IAxis>();
        ArrayList<String> allOperationQN = new ArrayList<String>();
        for (Object object : objectToAdd) {
            if (!this.isAllowedContents(object)) continue;
            allOperationQN.add("operation_of_stereotype:/" + ((NamedElement)object).getQualifiedName());
        }
        allOperationQN.removeAll(this.getElements());
        if (!allOperationQN.isEmpty()) {
            for (String operationQN : allOperationQN) {
                OperationIdAxis newAxis = NattableaxisFactory.eINSTANCE.createOperationIdAxis();
                newAxis.setElement(operationQN);
                newAxis.setManager(this.representedAxisManager);
                toAdd.add((IAxis)newAxis);
            }
        }
        return toAdd;
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        return new UMLStereotypeRestrictedOperationContentProvider(this, isRestricted);
    }

    public Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> umlProperties) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.getRepresentedContentProvider());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        ArrayList<String> propIdToDestroy = new ArrayList<String>();
        for (Object current : umlProperties) {
            if (current instanceof Operation && ((Operation)current).eContainer() instanceof Stereotype) {
                propIdToDestroy.add("operation_of_stereotype:/" + ((NamedElement)current).getQualifiedName());
                continue;
            }
            if (current instanceof String) {
                propIdToDestroy.add((String)current);
                continue;
            }
            if (!(current instanceof IAxis)) continue;
            propIdToDestroy.add(((IAxis)current).getElement().toString());
        }
        for (Object current : this.getRepresentedContentProvider().getAxis()) {
            String propId;
            if (!(current instanceof IdAxis) || !propIdToDestroy.contains(propId = AxisUtils.getPropertyId((Object)current))) continue;
            DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        if (!compositeCommand.isEmpty()) {
            return new AbstractAxisManager.RemoveCommandWrapper((AbstractAxisManager)this, (Command)new GMFtoEMFCommandWrapper((ICommand)compositeCommand), umlProperties);
        }
        return null;
    }

    public Object resolvedPath(String path) {
        if (path.startsWith("operation_of_stereotype:/")) {
            return StereotypeOperationUtils.getRealStereotypeOperation(this.getTableContext(), path);
        }
        return null;
    }

    public String getElementAxisName(IAxis axis) {
        String returnedValue = null;
        if (axis instanceof OperationIdAxis) {
            String elementId = ((OperationIdAxis)axis).getElement();
            Object resolvedElement = this.resolvedPath(elementId);
            if (resolvedElement instanceof NamedElement) {
                returnedValue = UMLLabelInternationalization.getInstance().getLabel((NamedElement)resolvedElement);
            } else {
                elementId = elementId.replace("operation_of_stereotype:/", "");
                String[] splitedElementId = elementId.split("::");
                returnedValue = splitedElementId[splitedElementId.length - 1];
            }
        }
        return returnedValue != null ? returnedValue : super.getElementAxisName(axis);
    }
}

