/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.Duration;
import org.eclipse.xwt.animation.IEasingFunction;
import org.eclipse.xwt.animation.RepeatBehavior;
import org.eclipse.xwt.animation.TimeSpan;
import org.eclipse.xwt.animation.Timeline;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.PathPropertyAccessor;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelinePropertyBuilder;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.TimelineEase;
import org.pushingpixels.trident.swt.SWTRepaintCallback;

public class TridentTimeline
implements ITimeline,
TimelineScenario.TimelineScenarioActor {
    protected org.pushingpixels.trident.Timeline tridentTimeline;
    protected Timeline xwtTimeline;
    protected Object target;
    private boolean isPlayed = false;
    private Collection<Runnable> stateChangedRunnables = new ArrayList<Runnable>();

    public TridentTimeline(Timeline xwtTimeline, Widget target) {
        this.xwtTimeline = xwtTimeline;
        this.target = target;
        this.tridentTimeline = this.createTimeline(target);
        this.tridentTimeline.addCallback(new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                for (Runnable runnable : TridentTimeline.this.getStateChangedRunnables()) {
                    runnable.run();
                }
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
            }
        });
    }

    public Collection<Runnable> getStateChangedRunnables() {
        return this.stateChangedRunnables;
    }

    @Override
    public void addStateChangedRunnable(Runnable stateChangedRunnable) {
        if (!this.stateChangedRunnables.contains(stateChangedRunnable)) {
            this.stateChangedRunnables.add(stateChangedRunnable);
        }
    }

    @Override
    public void removeStateChangedRunnable(Runnable stateChangedRunnable) {
        this.stateChangedRunnables.remove(stateChangedRunnable);
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public void play() {
        if (this.isPlayed) {
            this.tridentTimeline.replay();
        } else {
            Duration duration = this.xwtTimeline.getDuration();
            if (duration != null && duration.hasTimeSpan()) {
                this.tridentTimeline.setDuration((long)duration.getTimeSpan().getMilliseconds());
            } else {
                this.tridentTimeline.setDuration(10000L);
            }
            RepeatBehavior behavior = this.xwtTimeline.getRepeatBehavior();
            this.playLoop(behavior);
            this.isPlayed = true;
        }
    }

    protected void setInitialValue() {
    }

    protected org.pushingpixels.trident.Timeline createTimeline(Widget target) {
        org.pushingpixels.trident.Timeline timeline = new org.pushingpixels.trident.Timeline((Object)target);
        Control control = target instanceof Control ? (Control)target : (Control)XWT.findParent(target, Control.class);
        timeline.addCallback((TimelineCallback)new SWTRepaintCallback(control));
        Duration duration = this.xwtTimeline.getDuration();
        if (duration != null && duration.hasTimeSpan()) {
            timeline.setDuration((long)duration.getTimeSpan().getMilliseconds());
        } else {
            timeline.setDuration(10000L);
        }
        return timeline;
    }

    public void playLoop(RepeatBehavior behavior) {
        Timeline.RepeatBehavior loopBehavior = Timeline.RepeatBehavior.LOOP;
        if (this.xwtTimeline.isAutoReverse()) {
            loopBehavior = Timeline.RepeatBehavior.REVERSE;
        }
        if (behavior.getHasCount()) {
            double loopCount = behavior.getCount();
            if (!behavior.getHasDuration()) {
                this.tridentTimeline.playLoop((int)loopCount, loopBehavior);
            } else {
                Duration duration = behavior.getDuration();
                this.tridentTimeline.playLoopSkipping((int)loopCount, loopBehavior, (long)duration.getTimeSpan().getMilliseconds());
            }
        } else if (!behavior.getHasDuration()) {
            this.tridentTimeline.playLoop(loopBehavior);
        } else {
            Duration duration = behavior.getDuration();
            this.tridentTimeline.playLoopSkipping(loopBehavior, (long)duration.getTimeSpan().getMilliseconds());
        }
    }

    @Override
    public void end() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.end();
    }

    @Override
    public void cancel() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.cancel();
    }

    @Override
    public void abort() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.abort();
    }

    @Override
    public void pause() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.suspend();
    }

    @Override
    public void resume() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.resume();
    }

    @Override
    public void playReverse() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.playReverse();
    }

    public final <T> void addPropertyToInterpolate(String propName, T from, T to) {
        if (to == null) {
            throw new XWTException("\"to\" property of Animation cannot be null.");
        }
        TimelinePropertyBuilder builder = org.pushingpixels.trident.Timeline.property((String)propName);
        if (from == null) {
            builder.fromCurrent();
        } else {
            builder.from(from);
        }
        builder.to(to);
        int index = propName.indexOf(46);
        PathPropertyAccessor<T> propertyAccessor = null;
        if (index != -1) {
            propertyAccessor = new PathPropertyAccessor<T>(propName);
            builder.accessWith(propertyAccessor);
        }
        this.tridentTimeline.addPropertyToInterpolate(builder);
        TimeSpan timeSpan = this.xwtTimeline.getBeginTime();
        if (timeSpan != null && timeSpan.ticks != 0L) {
            this.tridentTimeline.setInitialDelay((long)timeSpan.getMilliseconds());
        } else if (from != null) {
            if (propertyAccessor != null) {
                propertyAccessor.set(this.target, propName, from);
            } else {
                TimelinePropertyBuilder.DefaultPropertySetter propertySetter = new TimelinePropertyBuilder.DefaultPropertySetter(this.target, propName);
                propertySetter.set(this.target, propName, from);
            }
        }
    }

    public void setEasingFunction(IEasingFunction easingFunction) {
        if (easingFunction != null) {
            this.tridentTimeline.setEase((TimelineEase)easingFunction);
        }
    }

    public boolean isDone() {
        return this.tridentTimeline.isDone();
    }

    public void resetDoneFlag() {
        this.tridentTimeline.resetDoneFlag();
    }

    public boolean supportsReplay() {
        return this.tridentTimeline.supportsReplay();
    }
}

