/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;

public class JavaReflectAccess {
    private static final Logger log = Logger.getLogger(JavaReflectAccess.class);
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private ClassFinder classFinder;

    @Inject(optional=true)
    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != this.classLoader) {
            this.classLoader = classLoader;
            this.classFinder = null;
        }
    }

    public Field getField(JvmField field) {
        Class<?> class1 = this.getRawType(field.getDeclaringType());
        if (class1 == null) {
            return null;
        }
        try {
            return class1.getDeclaredField(field.getSimpleName());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public Method getMethod(JvmOperation operation) {
        Class<?> declaringType = this.getRawType(operation.getDeclaringType());
        if (declaringType == null) {
            return null;
        }
        Class<?>[] paramTypes = this.getParamTypes(operation);
        try {
            return declaringType.getDeclaredMethod(operation.getSimpleName(), paramTypes);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public Constructor<?> getConstructor(JvmConstructor constructor) {
        Class<?> declaringType = this.getRawType(constructor.getDeclaringType());
        if (declaringType == null) {
            return null;
        }
        Class<?>[] paramTypes = this.getParamTypes(constructor);
        try {
            return declaringType.getDeclaredConstructor(paramTypes);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public Class<?> getRawType(JvmType type) {
        if (type.eIsProxy()) {
            throw new IllegalStateException("Cannot resolve proxy: " + EcoreUtil.getURI((EObject)type));
        }
        if (type instanceof JvmArrayType) {
            JvmComponentType componentType = ((JvmArrayType)type).getComponentType();
            Class<?> componentClass = this.getRawType(componentType);
            try {
                return (Class)this.getClassFinder().forName(componentClass.getName() + "[]");
            }
            catch (ClassNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }
        if (type instanceof JvmTypeParameter) {
            JvmTypeParameter tp = (JvmTypeParameter)type;
            EList constraints = tp.getConstraints();
            for (JvmTypeConstraint jvmTypeConstraint : constraints) {
                if (!(jvmTypeConstraint instanceof JvmUpperBound)) continue;
                return this.getRawType(jvmTypeConstraint.getTypeReference());
            }
            return Object.class;
        }
        try {
            return (Class)this.getClassFinder().forName(type.getIdentifier());
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    protected Class<?>[] getParamTypes(JvmExecutable exe) {
        EList<JvmFormalParameter> parameters = exe.getParameters();
        ArrayList result = Lists.newArrayList();
        for (JvmFormalParameter p : parameters) {
            result.add(this.getRawType(p.getParameterType()));
        }
        return result.toArray(new Class[result.size()]);
    }

    private Class<?> getRawType(JvmTypeReference ref) {
        Class<?> result = this.getRawType(ref.getType());
        return result;
    }

    public ClassFinder getClassFinder() {
        if (this.classFinder == null) {
            this.classFinder = new ClassFinder(this.classLoader);
        }
        return this.classFinder;
    }
}

