/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFactory;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureContextInheritanceRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureContextRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ArchitectureDomainRule {
    @Extension
    private static ArchitectureFactory factory = ArchitectureFactory.eINSTANCE;
    @Inject
    @Extension
    private ArchitectureExtensions _architectureExtensions;
    @Inject
    @Extension
    private ArchitectureContextRule _architectureContextRule;
    @Inject
    @Extension
    private ArchitectureContextInheritanceRule _architectureContextInheritanceRule;
    private final HashMap<ArrayList<?>, ArchitectureDomain> _createCache_inherit = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ArchitectureDomain> _createCache_merged = CollectionLiterals.newHashMap();

    public boolean hasExtensions(ArchitectureDomain domain) {
        Functions.Function1<ArchitectureContext, Boolean> _function = new Functions.Function1<ArchitectureContext, Boolean>(){

            public Boolean apply(ArchitectureContext it) {
                return ArchitectureDomainRule.this._architectureContextRule.hasExtensions(it);
            }
        };
        return IterableExtensions.exists((Iterable)domain.getContexts(), (Functions.Function1)_function);
    }

    public boolean isExtension(ArchitectureDomain domain) {
        Functions.Function1<ArchitectureContext, Boolean> _function = new Functions.Function1<ArchitectureContext, Boolean>(){

            public Boolean apply(ArchitectureContext it) {
                return it.isExtension();
            }
        };
        return IterableExtensions.exists((Iterable)domain.getContexts(), (Functions.Function1)_function);
    }

    public boolean hasInheritance(ArchitectureDomain domain) {
        Functions.Function1<ArchitectureContext, Boolean> _function = new Functions.Function1<ArchitectureContext, Boolean>(){

            public Boolean apply(ArchitectureContext it) {
                return ArchitectureDomainRule.this._architectureContextInheritanceRule.hasGeneral(it) || ArchitectureDomainRule.this._architectureContextInheritanceRule.hasSpecializations(it);
            }
        };
        return IterableExtensions.exists((Iterable)domain.getContexts(), (Functions.Function1)_function);
    }

    public boolean hasContexts(ArchitectureDomain domain) {
        boolean _isEmpty = domain.getContexts().isEmpty();
        return !_isEmpty;
    }

    public Iterable<ArchitectureContext> allContexts(ArchitectureDomain domain) {
        EList _contexts = domain.getContexts();
        Functions.Function1<ArchitectureDomain, EList<ArchitectureContext>> _function = new Functions.Function1<ArchitectureDomain, EList<ArchitectureContext>>(){

            public EList<ArchitectureContext> apply(ArchitectureDomain it) {
                return it.getContexts();
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap(this.allExtensions(domain), (Functions.Function1)_function);
        return Iterables.concat((Iterable)_contexts, (Iterable)_flatMap);
    }

    public Iterable<ArchitectureDomain> extensions(ArchitectureDomain extended) {
        Iterable<Object> _xifexpression = null;
        boolean _inExtensionsPhase = this._architectureExtensions.inExtensionsPhase();
        if (_inExtensionsPhase) {
            Functions.Function1<ArchitectureContext, Iterable<ArchitectureContext>> _function = new Functions.Function1<ArchitectureContext, Iterable<ArchitectureContext>>(){

                public Iterable<ArchitectureContext> apply(ArchitectureContext it) {
                    return ArchitectureDomainRule.this._architectureContextRule.extensions(it);
                }
            };
            Functions.Function1<ArchitectureContext, ArchitectureDomain> _function_1 = new Functions.Function1<ArchitectureContext, ArchitectureDomain>(){

                public ArchitectureDomain apply(ArchitectureContext it) {
                    return it.getDomain();
                }
            };
            _xifexpression = this._architectureExtensions.mapUnique(IterableExtensions.flatMap((Iterable)extended.getContexts(), (Functions.Function1)_function), _function_1);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        return _xifexpression;
    }

    public Iterable<ArchitectureDomain> allExtensions(ArchitectureDomain extended) {
        Iterable<Object> _xifexpression = null;
        boolean _inExtensionsPhase = this._architectureExtensions.inExtensionsPhase();
        if (_inExtensionsPhase) {
            Functions.Function1<ArchitectureContext, List<ArchitectureContext>> _function = new Functions.Function1<ArchitectureContext, List<ArchitectureContext>>(){

                public List<ArchitectureContext> apply(ArchitectureContext it) {
                    return ArchitectureDomainRule.this._architectureContextRule.allExtensions(it);
                }
            };
            Functions.Function1<ArchitectureContext, ArchitectureDomain> _function_1 = new Functions.Function1<ArchitectureContext, ArchitectureDomain>(){

                public ArchitectureDomain apply(ArchitectureContext it) {
                    return it.getDomain();
                }
            };
            _xifexpression = this._architectureExtensions.mapUnique(IterableExtensions.flatMap((Iterable)extended.getContexts(), (Functions.Function1)_function), _function_1);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        return _xifexpression;
    }

    public Iterable<ArchitectureDomain> generals(ArchitectureDomain specific) {
        Iterable<Object> _xifexpression = null;
        boolean _inInheritancePhase = this._architectureExtensions.inInheritancePhase();
        if (_inInheritancePhase) {
            Functions.Function1<ArchitectureContext, ArchitectureContext> _function = new Functions.Function1<ArchitectureContext, ArchitectureContext>(){

                public ArchitectureContext apply(ArchitectureContext it) {
                    return ArchitectureDomainRule.this._architectureContextInheritanceRule.general(it);
                }
            };
            Functions.Function1<ArchitectureContext, ArchitectureDomain> _function_1 = new Functions.Function1<ArchitectureContext, ArchitectureDomain>(){

                public ArchitectureDomain apply(ArchitectureContext it) {
                    return it.getDomain();
                }
            };
            _xifexpression = this._architectureExtensions.excluding(this._architectureExtensions.unique(IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)specific.getContexts(), (Functions.Function1)_function)), (Functions.Function1)_function_1)), specific);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        return _xifexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchitectureDomain inherit(ArchitectureDomain domain) {
        ArchitectureDomain _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ArchitectureDomain[]{domain});
        HashMap<ArrayList<?>, ArchitectureDomain> hashMap = this._createCache_inherit;
        synchronized (hashMap) {
            if (this._createCache_inherit.containsKey(_cacheKey)) {
                return this._createCache_inherit.get(_cacheKey);
            }
            _result = domain;
            this._createCache_inherit.put(_cacheKey, _result);
        }
        this._init_inherit(_result, domain);
        return _result;
    }

    private void _init_inherit(ArchitectureDomain it, final ArchitectureDomain domain) {
        Functions.Function1<ArchitectureDomain, ArchitectureDomain> _function = new Functions.Function1<ArchitectureDomain, ArchitectureDomain>(){

            public ArchitectureDomain apply(ArchitectureDomain it) {
                return ArchitectureDomainRule.this.inherit(it);
            }
        };
        Functions.Function0<Boolean> _function_1 = new Functions.Function0<Boolean>(){

            public Boolean apply() {
                boolean _xblockexpression = false;
                EList _concerns = domain.getConcerns();
                Functions.Function1<ArchitectureDomain, EList<Concern>> _function = new Functions.Function1<ArchitectureDomain, EList<Concern>>(){

                    public EList<Concern> apply(ArchitectureDomain it) {
                        return it.getConcerns();
                    }
                };
                Functions.Function1<Concern, String> _function_1 = new Functions.Function1<Concern, String>(){

                    public String apply(Concern it) {
                        return it.getName();
                    }
                };
                Functions.Function1<String, Concern> _function_2 = new Functions.Function1<String, Concern>(){

                    public Concern apply(String it) {
                        return (this).ArchitectureDomainRule.this._architectureExtensions.mergedConcern(it);
                    }
                };
                Iterable _map = IterableExtensions.map(ArchitectureDomainRule.this._architectureExtensions.mapUnique(IterableExtensions.flatMap(ArchitectureDomainRule.this._architectureExtensions.currentScope(), (Functions.Function1)_function), _function_1), (Functions.Function1)_function_2);
                Iterables.addAll((Collection)_concerns, (Iterable)_map);
                EList _stakeholders = domain.getStakeholders();
                Functions.Function1<ArchitectureDomain, EList<Stakeholder>> _function_3 = new Functions.Function1<ArchitectureDomain, EList<Stakeholder>>(){

                    public EList<Stakeholder> apply(ArchitectureDomain it) {
                        return it.getStakeholders();
                    }
                };
                Functions.Function1<Stakeholder, String> _function_4 = new Functions.Function1<Stakeholder, String>(){

                    public String apply(Stakeholder it) {
                        return it.getName();
                    }
                };
                Functions.Function1<String, Stakeholder> _function_5 = new Functions.Function1<String, Stakeholder>(){

                    public Stakeholder apply(String it) {
                        return (this).ArchitectureDomainRule.this._architectureExtensions.mergedStakeholder(it);
                    }
                };
                Iterable _map_1 = IterableExtensions.map(ArchitectureDomainRule.this._architectureExtensions.mapUnique(IterableExtensions.flatMap(ArchitectureDomainRule.this._architectureExtensions.currentScope(), (Functions.Function1)_function_3), _function_4), (Functions.Function1)_function_5);
                _xblockexpression = Iterables.addAll((Collection)_stakeholders, (Iterable)_map_1);
                return _xblockexpression;
            }
        };
        this._architectureExtensions.withScope((Iterable<? extends ArchitectureDomain>)IterableExtensions.map(this.generals(domain), (Functions.Function1)_function), _function_1);
        boolean _inInheritancePhase = this._architectureExtensions.inInheritancePhase();
        if (_inInheritancePhase) {
            Consumer<ArchitectureContext> _function_2 = new Consumer<ArchitectureContext>(){

                @Override
                public void accept(ArchitectureContext it) {
                    ArchitectureDomainRule.this._architectureContextInheritanceRule.inherit(it);
                }
            };
            domain.getContexts().forEach((Consumer)_function_2);
        }
    }

    public void finalizeInheritance(ArchitectureDomain domain) {
        Consumer<ArchitectureContext> _function = new Consumer<ArchitectureContext>(){

            @Override
            public void accept(ArchitectureContext it) {
                ArchitectureDomainRule.this._architectureContextInheritanceRule.finalizeInheritance(it);
            }
        };
        domain.getContexts().forEach((Consumer)_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchitectureDomain merged(ArchitectureDomain domain) {
        ArchitectureDomain _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ArchitectureDomain[]{domain});
        HashMap<ArrayList<?>, ArchitectureDomain> hashMap = this._createCache_merged;
        synchronized (hashMap) {
            ArchitectureDomain _createArchitectureDomain;
            if (this._createCache_merged.containsKey(_cacheKey)) {
                return this._createCache_merged.get(_cacheKey);
            }
            _result = _createArchitectureDomain = factory.createArchitectureDomain();
            this._createCache_merged.put(_cacheKey, _result);
        }
        this._init_merged(_result, domain);
        return _result;
    }

    private void _init_merged(final ArchitectureDomain it, final ArchitectureDomain domain) {
        Set<ArchitectureDomain> _of = Set.of(domain);
        Iterable<ArchitectureDomain> _allExtensions = this.allExtensions(domain);
        Functions.Function0<ArchitectureDomain> _function = new Functions.Function0<ArchitectureDomain>(){

            public ArchitectureDomain apply() {
                ArchitectureDomain _copy = ArchitectureDomainRule.this._architectureExtensions.copy(it, domain);
                Procedures.Procedure1<ArchitectureDomain> _function = new Procedures.Procedure1<ArchitectureDomain>(){

                    public void apply(final ArchitectureDomain result) {
                        EList _concerns = it.getConcerns();
                        Functions.Function1<ArchitectureDomain, EList<Concern>> _function = new Functions.Function1<ArchitectureDomain, EList<Concern>>(){

                            public EList<Concern> apply(ArchitectureDomain it) {
                                return it.getConcerns();
                            }
                        };
                        Functions.Function1<Concern, String> _function_1 = new Functions.Function1<Concern, String>(){

                            public String apply(Concern it) {
                                return it.getName();
                            }
                        };
                        Functions.Function1<String, Concern> _function_2 = new Functions.Function1<String, Concern>(){

                            public Concern apply(String it) {
                                return ((this).this).ArchitectureDomainRule.this._architectureExtensions.mergedConcern(it);
                            }
                        };
                        Iterable _map = IterableExtensions.map((this).ArchitectureDomainRule.this._architectureExtensions.mapUnique(IterableExtensions.flatMap((this).ArchitectureDomainRule.this._architectureExtensions.currentScope(), (Functions.Function1)_function), _function_1), (Functions.Function1)_function_2);
                        Iterables.addAll((Collection)_concerns, (Iterable)_map);
                        EList _stakeholders = it.getStakeholders();
                        Functions.Function1<ArchitectureDomain, EList<Stakeholder>> _function_3 = new Functions.Function1<ArchitectureDomain, EList<Stakeholder>>(){

                            public EList<Stakeholder> apply(ArchitectureDomain it) {
                                return it.getStakeholders();
                            }
                        };
                        Functions.Function1<Stakeholder, String> _function_4 = new Functions.Function1<Stakeholder, String>(){

                            public String apply(Stakeholder it) {
                                return it.getName();
                            }
                        };
                        Functions.Function1<String, Stakeholder> _function_5 = new Functions.Function1<String, Stakeholder>(){

                            public Stakeholder apply(String it) {
                                return ((this).this).ArchitectureDomainRule.this._architectureExtensions.mergedStakeholder(it);
                            }
                        };
                        Iterable _map_1 = IterableExtensions.map((this).ArchitectureDomainRule.this._architectureExtensions.mapUnique(IterableExtensions.flatMap((this).ArchitectureDomainRule.this._architectureExtensions.currentScope(), (Functions.Function1)_function_3), _function_4), (Functions.Function1)_function_5);
                        Iterables.addAll((Collection)_stakeholders, (Iterable)_map_1);
                        EList _contexts = it.getContexts();
                        Functions.Function1<ArchitectureContext, Boolean> _function_6 = new Functions.Function1<ArchitectureContext, Boolean>(){

                            public Boolean apply(ArchitectureContext it) {
                                return it.isExtension();
                            }
                        };
                        Functions.Function1<ArchitectureContext, ArchitectureContext> _function_7 = new Functions.Function1<ArchitectureContext, ArchitectureContext>(){

                            public ArchitectureContext apply(ArchitectureContext it) {
                                return ((this).this).ArchitectureDomainRule.this._architectureContextRule.merged(it);
                            }
                        };
                        Iterable _map_2 = IterableExtensions.map((Iterable)IterableExtensions.reject(ArchitectureDomainRule.this.allContexts(domain), (Functions.Function1)_function_6), (Functions.Function1)_function_7);
                        Iterables.addAll((Collection)_contexts, (Iterable)_map_2);
                        Consumer<ArchitectureDomain> _function_8 = new Consumer<ArchitectureDomain>(){

                            @Override
                            public void accept(ArchitectureDomain it) {
                                ((this).this).ArchitectureDomainRule.this._architectureExtensions.traceTo(result, it);
                            }
                        };
                        ArchitectureDomainRule.this.allExtensions(domain).forEach(_function_8);
                    }
                };
                return (ArchitectureDomain)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
            }
        };
        this._architectureExtensions.withScope((Iterable<? extends ArchitectureDomain>)Iterables.concat(_of, _allExtensions), _function);
    }

    public void inferExtensions(ArchitectureDomain domain) {
        Functions.Function1<ArchitectureContext, Boolean> _function = new Functions.Function1<ArchitectureContext, Boolean>(){

            public Boolean apply(ArchitectureContext it) {
                return ArchitectureDomainRule.this._architectureContextInheritanceRule.legacyContext(it);
            }
        };
        Consumer<ArchitectureContext> _function_1 = new Consumer<ArchitectureContext>(){

            @Override
            public void accept(ArchitectureContext it) {
                ArchitectureDomainRule.this._architectureContextRule.inferExtensions(it);
            }
        };
        IterableExtensions.filter((Iterable)domain.getContexts(), (Functions.Function1)_function).forEach(_function_1);
    }
}

