/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.notification;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.xtext.common.types.ui.notification.TypeNames;
import org.eclipse.xtext.naming.QualifiedName;

public class JavaBuilderState {
    private static final Logger LOG = Logger.getLogger(JavaBuilderState.class);
    private final State state;
    private final IProject project;
    private Integer buildNumber;
    private Object references;
    private Long lastStructuralBuildTime;
    private Set<QualifiedName> structurallyChangedTypes;

    private JavaBuilderState(IProject project, State state) {
        this.project = project;
        this.state = state;
    }

    public IProject getProject() {
        return this.project;
    }

    public static JavaBuilderState getLastBuiltState(IJavaElement javaElement) {
        IJavaProject javaProject = javaElement.getJavaProject();
        return javaProject == null ? null : JavaBuilderState.getLastBuiltState(javaProject.getProject());
    }

    public static JavaBuilderState getLastBuiltState(IProject project) {
        Object lastBuiltState = JavaModelManager.getJavaModelManager().getLastBuiltState(project, null);
        State state = lastBuiltState instanceof State ? (State)lastBuiltState : null;
        return new JavaBuilderState(project, state);
    }

    public Long getLastStructuralBuildTime() {
        if (this.lastStructuralBuildTime != null) {
            return this.lastStructuralBuildTime;
        }
        if (this.state == null) {
            this.lastStructuralBuildTime = -1L;
            return this.lastStructuralBuildTime;
        }
        this.lastStructuralBuildTime = (Long)this.readField(this.state, "lastStructuralBuildTime", -1L);
        return this.lastStructuralBuildTime;
    }

    public Integer getBuildNumber() {
        if (this.buildNumber != null) {
            return this.buildNumber;
        }
        if (this.state == null) {
            this.buildNumber = -1;
            return this.buildNumber;
        }
        this.buildNumber = (Integer)this.readField(this.state, "buildNumber", -1);
        return this.buildNumber;
    }

    public Set<QualifiedName> getStructurallyChangedTypes() {
        Object types;
        if (this.structurallyChangedTypes != null) {
            return this.structurallyChangedTypes;
        }
        this.structurallyChangedTypes = new HashSet<QualifiedName>();
        if (this.state != null && (types = this.readField(this.state, "structurallyChangedTypes", null)) instanceof StringSet) {
            String[] stringArray = ((StringSet)types).values;
            int n = ((StringSet)types).values.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name != null) {
                    this.structurallyChangedTypes.add(QualifiedName.create((String[])name.split("/")));
                }
                ++n2;
            }
        }
        return this.structurallyChangedTypes;
    }

    public TypeNames getQualifiedTypeNames(Object obj) {
        if (obj instanceof ICompilationUnit) {
            return this._getQualifiedTypeNames((ICompilationUnit)obj);
        }
        if (obj instanceof IPackageFragment) {
            return this._getQualifiedTypeNames((IPackageFragment)obj);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(obj).toString());
    }

    protected TypeNames _getQualifiedTypeNames(IPackageFragment packageFragment) {
        TypeNames qualifiedTypeNames = new TypeNames(packageFragment.getJavaProject());
        Object references = this.getReferences();
        if (references == null) {
            return qualifiedTypeNames;
        }
        IResource resource = packageFragment.getResource();
        if (resource == null) {
            return qualifiedTypeNames;
        }
        String packageName = packageFragment.getElementName();
        IPath packagePath = resource.getProjectRelativePath();
        int srcPathSegmentCount = this.getPackageFragmentRoot((IJavaElement)packageFragment).getResource().getProjectRelativePath().segmentCount();
        Collection<Object> keys = references instanceof Map ? ((Map)references).keySet() : Arrays.asList(((SimpleLookupTable)references).keyTable);
        for (Object t : keys) {
            IPath qualifiedPath;
            String typePackageName;
            IPath typeLocatorPath;
            if (!(t instanceof String) || !packagePath.isPrefixOf(typeLocatorPath = packageFragment.getJavaProject().getProject().getFile((String)t).getProjectRelativePath()) || !packageName.equals(typePackageName = (qualifiedPath = typeLocatorPath.removeFirstSegments(srcPathSegmentCount).removeFileExtension()).removeLastSegments(1).toString().replace("/", "."))) continue;
            String simpleTypeName = qualifiedPath.lastSegment().toString();
            qualifiedTypeNames.addAll(this.getQualifiedTypeNames((String)t, packageName, simpleTypeName, packageFragment.getJavaProject()));
        }
        return qualifiedTypeNames;
    }

    protected TypeNames _getQualifiedTypeNames(ICompilationUnit compilationUnit) {
        return this.getQualifiedTypeNames(this.getTypeLocator(compilationUnit), this.getPackageName(compilationUnit), this.getSimplePrimaryTypeName(compilationUnit), compilationUnit.getJavaProject());
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaElement javaElement) {
        IJavaElement parent = javaElement.getParent();
        return parent instanceof IPackageFragmentRoot ? (IPackageFragmentRoot)parent : this.getPackageFragmentRoot(parent);
    }

    private TypeNames getQualifiedTypeNames(String typeLocator, String packageName, String simpleName, IJavaProject project) {
        TypeNames qualifiedTypeNames = new TypeNames(project);
        String primaryTypeFqn = this.getQualifedTypeName(packageName, simpleName);
        char[][] typeNames = null;
        if (this.state != null) {
            typeNames = this.state.getDefinedTypeNamesFor(typeLocator);
        }
        if (typeNames == null) {
            TypeNames newTypeNames = new TypeNames(project);
            newTypeNames.addTypeName(primaryTypeFqn, primaryTypeFqn);
            return newTypeNames;
        }
        char[][] cArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            char[] typeName = cArray[n2];
            String qualifiedTypeName = this.getQualifedTypeName(packageName, new String(typeName));
            qualifiedTypeNames.addTypeName(qualifiedTypeName, primaryTypeFqn);
            ++n2;
        }
        return qualifiedTypeNames;
    }

    private String getQualifedTypeName(String packageName, String simpleTypeName) {
        return packageName == null ? simpleTypeName : String.valueOf(packageName) + "." + simpleTypeName;
    }

    private String getTypeLocator(ICompilationUnit compilationUnit) {
        IResource resource = compilationUnit.getResource();
        if (resource != null && resource.getProjectRelativePath() != null) {
            return resource.getProjectRelativePath().toString();
        }
        return null;
    }

    private String getPackageName(ICompilationUnit compilationUnit) {
        IJavaElement parent = compilationUnit.getParent();
        if (parent instanceof IPackageFragment && !((IPackageFragment)parent).isDefaultPackage()) {
            return ((IPackageFragment)parent).getElementName();
        }
        return null;
    }

    private String getSimplePrimaryTypeName(ICompilationUnit compilationUnit) {
        String elementName = compilationUnit.getElementName();
        return elementName.substring(0, elementName.lastIndexOf("."));
    }

    private Object getReferences() {
        if (this.references != null) {
            return this.references;
        }
        if (this.state == null) {
            return null;
        }
        Object readReferences = this.readField(this.state, "references", null);
        if (readReferences instanceof Map) {
            this.references = readReferences;
        } else if (readReferences instanceof SimpleLookupTable) {
            this.references = readReferences;
        }
        return this.references;
    }

    private Object readField(Object instance, String fieldName, Object defaultValue) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(instance);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }
}

