/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.basecs.ParameterCS;
import org.eclipse.ocl.xtext.basecs.TypeRefCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.completeoclcs.ClassifierContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.xtext.completeoclcs.DefCS;
import org.eclipse.ocl.xtext.completeoclcs.DefOperationCS;
import org.eclipse.ocl.xtext.completeoclcs.DefPropertyCS;
import org.eclipse.ocl.xtext.completeoclcs.OperationContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.PackageDeclarationCS;
import org.eclipse.ocl.xtext.completeoclcs.PropertyContextDeclCS;
import org.eclipse.ocl.xtext.essentialocl.ui.labeling.EssentialOCLLabelProvider;

public class CompleteOCLLabelProvider
extends EssentialOCLLabelProvider {
    @Inject
    public CompleteOCLLabelProvider(@NonNull AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected String image(ClassifierContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Class.gif";
    }

    protected String text(ClassifierContextDeclCS ele) {
        Class classifier = ele.getReferredClass();
        if (classifier == null) {
            return "<<null>>";
        }
        if (classifier.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        return classifier.getName();
    }

    protected String image(CompleteOCLDocumentCS ele) {
        return "/org.eclipse.ocl.xtext.completeocl.ui/icons/OCLModelFile.gif";
    }

    protected String text(CompleteOCLDocumentCS ele) {
        Model root = (Model)PivotUtil.getPivot(Model.class, (Pivotable)ele);
        return root != null ? String.valueOf(root.getName()) : "null";
    }

    protected String image(DefCS ele) {
        return "/org.eclipse.ocl.xtext.oclinecore.ui/icons/full/obj16/DefinitionConstraint.gif";
    }

    protected String text(DefCS ele) {
        StringBuilder s = new StringBuilder();
        s.append("def ");
        this.appendOptionalString(s, ele.getName());
        s.append(": ");
        return s.toString();
    }

    protected String text(DefOperationCS ele) {
        StringBuilder s = new StringBuilder();
        this.appendString(s, ele.getName());
        EList parameters = ele.getOwnedParameters();
        if (!parameters.isEmpty()) {
            s.append("(");
            String prefix = "";
            for (ParameterCS csParameter : parameters) {
                s.append(prefix);
                this.appendType(s, (TypeRefCS)csParameter.getOwnedType());
                prefix = ", ";
            }
            s.append(")");
        }
        s.append(" : ");
        TypedRefCS ownedType = ele.getOwnedType();
        if (ownedType != null) {
            this.appendType(s, (TypeRefCS)ownedType);
        }
        return s.toString();
    }

    protected String text(DefPropertyCS ele) {
        StringBuilder s = new StringBuilder();
        this.appendString(s, ele.getName());
        s.append(" : ");
        this.appendType(s, (TypeRefCS)ele.getOwnedType());
        return s.toString();
    }

    protected String image(OperationContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Operation.gif";
    }

    protected String text(OperationContextDeclCS ele) {
        StringBuilder s = new StringBuilder();
        Operation operation = ele.getReferredOperation();
        if (operation == null) {
            return "<<null>>";
        }
        if (operation.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        this.appendName(s, (NamedElement)operation.getOwningClass());
        s.append("::");
        this.appendName(s, (NamedElement)operation);
        s.append("(");
        String prefix = "";
        for (Parameter parameter : operation.getOwnedParameters()) {
            s.append(prefix);
            this.appendType(s, parameter.getType());
            prefix = ", ";
        }
        s.append(")");
        s.append(" : ");
        this.appendType(s, operation.getType());
        return s.toString();
    }

    protected String image(PackageDeclarationCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Package.gif";
    }

    protected String text(PackageDeclarationCS csElement) {
        assert (csElement != null);
        Package asElement = csElement.getReferredPackage();
        if (asElement == null) {
            asElement = PivotUtil.getPivot(Element.class, (Pivotable)csElement);
        }
        if (asElement != null) {
            return String.valueOf(this.doGetText(asElement));
        }
        return "<<null>>";
    }

    protected String image(PropertyContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Property.gif";
    }

    protected String text(PropertyContextDeclCS ele) {
        StringBuilder s = new StringBuilder();
        Property feature = ele.getReferredProperty();
        if (feature == null) {
            return "<<null>>";
        }
        if (feature.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        this.appendName(s, (NamedElement)feature.getOwningClass());
        s.append("::");
        this.appendName(s, (NamedElement)feature);
        s.append(" : ");
        this.appendType(s, feature.getType());
        return s.toString();
    }
}

